/* This file is part of the KDE project
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef GNUMERICEXPORT_TEST_H
#define GNUMERICEXPORT_TEST_H

#include <KoFilter.h>
#include <tqdom.h>

namespace KSpread
{
  class Cell;
}

class GNUMERICExport : public KoFilter {

    Q_OBJECT
  

public:
    GNUMERICExport(KoFilter *parent, const char*name, const TQStringList&);
    virtual ~GNUMERICExport() {}

    virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );

private:
    TQDomElement GetCellStyle(TQDomDocument gnumeric_doc, KSpread::Cell* cell, int currentcolumn, int currentrow);
    TQDomElement GetBorderStyle(TQDomDocument gnumeric_doc, KSpread::Cell* cell, int currentcolumn, int currentrow);
    TQDomElement GetFontStyle(TQDomDocument gnumeric_doc, KSpread::Cell* cell, int currentcolumn, int currentrow);
    TQDomElement GetLinkStyle(TQDomDocument gnumeric_doc );
    TQDomElement GetValidity( TQDomDocument gnumeric_doc, KSpread::Cell* cell );

    void addAttributeItem(TQDomDocument gnumeric_doc, TQDomElement attributes, const TQString& type, const TQString& name, bool value);
    void addSummaryItem(TQDomDocument gnumeric_doc, TQDomElement summary, const TQString& name, const TQString& value);
    bool hasBorder(KSpread::Cell*cell, int currentcolumn, int currentrow);
    const TQString ColorToString(int red, int green, int blue);
    TQString convertVariable( TQString headerFooter );
    TQString convertRefToRange( const TQString & table, const TQRect & rect );
    TQString convertRefToBase( const TQString & table, const TQRect & rect );
    bool isLink;
    TQString linkText;
    TQString linkUrl;
    bool isLinkBold;
    bool isLinkItalic;

};
#endif

