#include "conversion.h"
#include <kdebug.h>
#include <tdelocale.h>

TQString Conversion::importAlignment( const TQString& align )
{
    if ( align == "center" || align == "justify" )
        return align;
    if ( align == "start" )
        return "left";
    if ( align == "end" )
        return "right";
    kdWarning(30518) << "Conversion::importAlignment unknown alignment " << align << endl;
    return "auto";
}

TQString Conversion::exportAlignment( const TQString& align )
{
    if ( align == "center" || align == "justify" )
        return align;
    if ( align == "left" || align == "auto" ) // auto handled by text-auto-align
        return "start";
    if ( align == "right" )
        return "end";
    kdWarning(30518) << "Conversion::exportAlignment unknown alignment " << align << endl;
    return "auto";
}

TQPair<int,TQString> Conversion::importWrapping( const TQString& oowrap )
{
    if ( oowrap == "none" )
        // 'no wrap' means 'avoid horizontal space'
        return tqMakePair( 2, TQString() );
    if ( oowrap == "left" || oowrap == "right" )
        // Left and right, no problem
        return tqMakePair( 1, oowrap );
    if ( oowrap == "run-through" )
        return tqMakePair( 0, TQString() );
    if ( oowrap == "biggest" ) // OASIS extension
        return tqMakePair( 1, TQString::fromLatin1( "biggest" ) );

    ////if ( oowrap == "parallel" || oowrap == "dynamic" )
    // dynamic is called "optimal" in the OO GUI. It's different from biggest because it can lead to parallel.

    // Those are not supported in KWord, let's use biggest instead
    return tqMakePair( 1, TQString::fromLatin1( "biggest" ) );
}

TQString Conversion::exportWrapping( const TQPair<int,TQString>& runAroundAttribs )
{
    switch( runAroundAttribs.first ) {
    case 0:
        return "run-through";
    case 1: // left, right, or biggest -> ok
        return runAroundAttribs.second;
    case 2:
        return "none";
    default:
        return "ERROR"; // ERROR
    }
}

int Conversion::importOverflowBehavior( const TQString& oasisOverflowBehavior )
{
    if ( oasisOverflowBehavior == "auto-extend-frame" )
        return 0; // AutoExtendFrame
    if ( oasisOverflowBehavior == "auto-create-new-frame" )
        return 1; // AutoCreateNewFrame
    if ( oasisOverflowBehavior == "ignore" )
        return 2; // Ignore extra text
    kdWarning(30518) << "Invalid overflow behavior " << oasisOverflowBehavior << endl;
    return 0;
}

TQString Conversion::exportOverflowBehavior( const TQString& kwordAutoCreateNewFrame )
{
    switch ( kwordAutoCreateNewFrame.toInt() ) {
    case 1:
        return "auto-create-new-frame";
    case 2:
        return "ignore";
    default:
    case 0:
        return "auto-extend-frame";
    }
}

int Conversion::importCounterType( const TQString& numFormat )
{
    if ( numFormat == "1" )
        return 1;
    if ( numFormat == "a" )
        return 2;
    if ( numFormat == "A" )
        return 3;
    if ( numFormat == "i" )
        return 4;
    if ( numFormat == "I" )
        return 5;
    return 0;
}

TQString Conversion::headerTypeToFramesetName( const TQString& localName, bool hasEvenOdd )
{
    if ( localName == "header" )
        return hasEvenOdd ? i18n("Odd Pages Header") : i18n( "Header" );
    if ( localName == "header-left" )
        return i18n("Even Pages Header");
    if ( localName == "footer" )
        return hasEvenOdd ? i18n("Odd Pages Footer") : i18n( "Footer" );
    if ( localName == "footer-left" )
        return i18n("Even Pages Footer");
    kdWarning(30518) << "Unknown tag in headerTypeToFramesetName: " << localName << endl;
    // ######
    //return i18n("First Page Header");
    //return i18n("First Page Footer");
    return TQString();
}

int Conversion::headerTypeToFrameInfo( const TQString& localName, bool /*hasEvenOdd*/ )
{
    if ( localName == "header" )
        return 3; // odd headers
    if ( localName == "header-left" )
        return 2; // even headers
    if ( localName == "footer" )
        return 6; // odd footers
    if ( localName == "footer-left" )
        return 5; // even footers

    // ### return 1; // first header
    // ### return 4; // first footer
    return 0;
}
