/* This file is part of the KDE project
   Copyright (C) 2003 Adam Pigg <adam@piggz.co.uk>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDB_DRIVER_PQXX_H
#define KEXIDB_DRIVER_PQXX_H

#include <tqstringlist.h>

#include <kexidb/driver.h>

namespace KexiDB
{

class Connection;
class DriverManager;

//! PostgreSQL database driver.
class pqxxSqlDriver : public Driver
{
	Q_OBJECT
  
	KEXIDB_DRIVER

	public:
		pqxxSqlDriver( TQObject *parent, const char *name, const TQStringList &args = TQStringList() );
		~pqxxSqlDriver();

		virtual bool isSystemObjectName( const TQString& n )const;
		virtual bool isSystemDatabaseName( const TQString& n )const;

		//! Escape a string for use as a value
		virtual TQString escapeString( const TQString& str) const;
		virtual TQCString escapeString( const TQCString& str) const;
		virtual TQString sqlTypeName(int id_t, int p=0) const;

		//! Escape BLOB value \a array
		virtual TQString escapeBLOB(const TQByteArray& array) const;

		/*! Escapes and converts value \a v (for type \a ftype) 
		 to string representation required by SQL commands.
		 Reimplemented for boolean type only to use SQL compliant TRUE or FALSE */
		virtual TQString valueToSQL( uint ftype, const TQVariant& v ) const;

	protected:
		virtual TQString drv_escapeIdentifier( const TQString& str) const;
		virtual TQCString drv_escapeIdentifier( const TQCString& str) const;
		virtual Connection *drv_createConnection( ConnectionData &conn_data );
		virtual bool drv_isSystemFieldName( const TQString& n )const;

	private:
		static const char *keywords[];
};

};

#endif
