/* This file is part of the KDE project
   Copyright (C) 2004 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXINAMEDIALOG_H
#define KEXINAMEDIALOG_H

#include <kdialogbase.h>

#include "kexinamewidget.h"

class KEXIMAIN_EXPORT KexiNameDialog : public KDialogBase
{
	Q_OBJECT
  

	public:
		KexiNameDialog(const TQString& message, 
			TQWidget * parent = 0, const char * name = 0);

		KexiNameDialog(const TQString& message, 
			const TQString& nameLabel, const TQString& nameText, 
			const TQString& captionLabel, const TQString& captionText, 
			TQWidget * parent = 0, const char * name = 0);
		
		virtual ~KexiNameDialog();

		KexiNameWidget* widget() const { return m_widget; }

		virtual void show();

	public slots:
		virtual void setDialogIcon(const TQPixmap& icon);

	protected slots:
		void slotTextChanged();
		virtual void accept();
		void updateSize();
	
	protected:
		void init();

		TQLabel *m_icon;
		KexiNameWidget* m_widget;
};

#endif
