/* This file is part of the KDE project
   Copyright (C) 2004 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tdelocale.h>

#include "kptcalendareditbase.h"

#include <tqvariant.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <kptcalendarpanel.h>
#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqbuttongroup.h>
#include <tqheader.h>
#include <tqlistview.h>
#include <tqdatetimeedit.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

namespace KPlato
{

/*
 *  Constructs a CalendarEditBase as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
CalendarEditBase::CalendarEditBase( TQWidget* parent, const char* name, WFlags fl )
    : TQWidget( parent, name, fl )
{
    if ( !name )
	setName( "CalendarEditBase" );
    CalendarEditBaseLayout = new TQHBoxLayout( this, 0, 0, "CalendarEditBaseLayout");

    groupBox2 = new TQGroupBox( this, "groupBox2" );
    groupBox2->setColumnLayout(0, Qt::Vertical );
    groupBox2->layout()->setSpacing( 6 );
    groupBox2->layout()->setMargin( 6 );
    groupBox2Layout = new TQGridLayout( groupBox2->layout() );
    groupBox2Layout->setAlignment( TQt::AlignTop );

    calendarPanel = new CalendarPanel( groupBox2, "calendarPanel" );

    groupBox2Layout->addWidget( calendarPanel, 1, 0 );

    day = new TQButtonGroup( groupBox2, "day" );
    day->setColumnLayout(0, Qt::Vertical );
    day->layout()->setSpacing( 6 );
    day->layout()->setMargin( 6 );
    dayLayout = new TQVBoxLayout( day->layout() );
    dayLayout->setAlignment( TQt::AlignTop );

    layout8 = new TQHBoxLayout( 0, 0, 6, "layout8");

    state = new TQComboBox( FALSE, day, "state" );
    layout8->addWidget( state );

    bApply = new TQPushButton( day, "bApply" );
    layout8->addWidget( bApply );
    dayLayout->addLayout( layout8 );

    groupBox4 = new TQGroupBox( day, "groupBox4" );
    groupBox4->setColumnLayout(0, Qt::Vertical );
    groupBox4->layout()->setSpacing( 6 );
    groupBox4->layout()->setMargin( 6 );
    groupBox4Layout = new TQVBoxLayout( groupBox4->layout() );
    groupBox4Layout->setAlignment( TQt::AlignTop );

    intervalList = new TQListView( groupBox4, "intervalList" );
    intervalList->addColumn( tr2i18n( "Work Interval" ) );
    groupBox4Layout->addWidget( intervalList );

    layout6 = new TQHBoxLayout( 0, 0, 6, "layout6");

    startTime = new TQTimeEdit( groupBox4, "startTime" );
    layout6->addWidget( startTime );

    endTime = new TQTimeEdit( groupBox4, "endTime" );
    layout6->addWidget( endTime );
    groupBox4Layout->addLayout( layout6 );

    layout5 = new TQHBoxLayout( 0, 0, 6, "layout5");

    bClear = new TQPushButton( groupBox4, "bClear" );
    layout5->addWidget( bClear );

    bAddInterval = new TQPushButton( groupBox4, "bAddInterval" );
    layout5->addWidget( bAddInterval );
    groupBox4Layout->addLayout( layout5 );
    dayLayout->addWidget( groupBox4 );

    groupBox2Layout->addWidget( day, 1, 1 );
    CalendarEditBaseLayout->addWidget( groupBox2 );
    languageChange();
    resize( TQSize(540, 340).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

/*
 *  Destroys the object and frees any allocated resources
 */
CalendarEditBase::~CalendarEditBase()
{
    // no need to delete child widgets, TQt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CalendarEditBase::languageChange()
{
    setCaption( tr2i18n( "CalendarEditBase" ) );
    groupBox2->setTitle( TQString() );
    day->setTitle( TQString() );
    bApply->setText( tr2i18n( "Apply" ) );
    groupBox4->setTitle( TQString() );
    intervalList->header()->setLabel( 0, tr2i18n( "Work Interval" ) );
    bClear->setText( tr2i18n( "Clear" ) );
    bAddInterval->setText( tr2i18n( "Add Interval" ) );
}

}  //KPlato namespace

#include "kptcalendareditbase.moc"
