/* This file is part of the KDE project
   Copyright (C) 2005 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kptwbsdefinitionpanel.h"
#include "kptwbsdefinition.h"
#include "kptcommand.h"
#include "kptpart.h"

#include <tdelocale.h>
#include <kdebug.h>

#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqmemarray.h>
#include <tqpushbutton.h>
#include <tqstringlist.h>
#include <tqspinbox.h>
#include <tqtable.h>

namespace KPlato
{

WBSDefinitionPanel::WBSDefinitionPanel(WBSDefinition &def, TQWidget *p, const char *n)
    : WBSDefinitionPanelBase(p, n),
      m_def(def)
{
    removeBtn->setEnabled(false);
    
    TQStringList codeList = def.codeList();
    defaultSeparator->setText(def.defaultSeparator());
    defaultCode->insertStringList(codeList);
    defaultCode->setCurrentItem(def.defaultCodeIndex());
    defaultCode->setFocus();
    
    levelsGroup->setChecked(def.isLevelsDefEnabled());
    int i = 0;
    const TQMap<int, WBSDefinition::CodeDef> &lev = def.levelsDef();
    levelsTable->setNumRows(lev.count());
    kdDebug()<<"Map size="<<lev.count()<<endl;
    TQMap<int, WBSDefinition::CodeDef>::const_iterator it;
    for (it = lev.begin(); it != lev.end(); ++it) {
        levelsTable->verticalHeader()->setLabel(i, TQString("%1").arg(it.key()));
        TQComboTableItem *item = new TQComboTableItem(levelsTable, codeList, true);
        item->setCurrentItem(it.data().code);
        levelsTable->setItem(i, 0, item);
        levelsTable->setText(i, 1, it.data().separator);
        i++;
    }
    levelsTable->setColumnStretchable(0, true);
    slotLevelChanged(level->value());
    
    connect(defaultCode, TQT_SIGNAL(activated(int)), TQT_SLOT(slotChanged()));
    connect(defaultSeparator, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(slotChanged()));
    connect(levelsGroup, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotLevelsGroupToggled(bool)));
    connect(levelsTable, TQT_SIGNAL(valueChanged(int, int)), TQT_SLOT(slotChanged()));
    connect(levelsTable, TQT_SIGNAL(selectionChanged()), TQT_SLOT(slotSelectionChanged()));
    connect(level, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(slotLevelChanged(int)));
    connect(removeBtn, TQT_SIGNAL(clicked()), TQT_SLOT(slotRemoveBtnClicked()));
    connect(addBtn, TQT_SIGNAL(clicked()), TQT_SLOT(slotAddBtnClicked()));
}

void WBSDefinitionPanel::setStartValues(Part */*part*/) {
}

KMacroCommand *WBSDefinitionPanel::buildCommand(Part */*part*/) {
    KMacroCommand *cmd = new KMacroCommand(i18n("Modify WBS Definition"));

    return cmd;
}

bool WBSDefinitionPanel::ok() {
    m_def.setDefaultCode(defaultCode->currentItem());
    m_def.setDefaultSeparator(defaultSeparator->text());
    
    m_def.setLevelsDefEnabled(levelsGroup->isChecked());

    m_def.clearLevelsDef();
    for (int i = 0; i < levelsTable->numRows(); ++i) {
        m_def.setLevelsDef(levelsTable->verticalHeader()->label(i).toInt(), levelsTable->text(i, 0), levelsTable->text(i, 1));
    }
    return true;
}

void WBSDefinitionPanel::slotChanged() {
    emit changed(true);
}

void WBSDefinitionPanel::slotSelectionChanged() {
    TQString s;
    bool rowSelected = false;
    for (int i=0; i < levelsTable->numRows(); ++i) {
        if (levelsTable->isRowSelected(i, true)) {
            s += TQString("Row[%1]=selected ").arg(i);
            rowSelected = true;
        }
    }
    removeBtn->setEnabled(rowSelected);
    if (s.isEmpty()) s = "None selected";
    kdDebug()<<k_funcinfo<<s<<endl;
}

void WBSDefinitionPanel::slotRemoveBtnClicked() {
    TQMemArray<int> rows;
    for (int i=0; i < levelsTable->numRows(); ++i) {
        if (levelsTable->isRowSelected(i)) {
            rows.resize(rows.size()+1);
            rows[rows.size()-1] = i;
        }
    }
    levelsTable->removeRows(rows);
    removeBtn->setEnabled(false);
    slotLevelChanged(level->value());
}

void WBSDefinitionPanel::slotAddBtnClicked() {
    kdDebug()<<k_funcinfo<<endl;
    int i=levelsTable->numRows()-1;
    for (; i >= 0; --i) {
        kdDebug()<<k_funcinfo<<"Checking row["<<i<<"]="<<levelsTable->verticalHeader()->label(i)<<" with "<<level->value()<<endl;
        if (level->value() > levelsTable->verticalHeader()->label(i).toInt()) {
            break;
        }
    }
    i++;
    levelsTable->insertRows(i);
    levelsTable->verticalHeader()->setLabel(i, TQString("%1").arg(level->value()));
    TQComboTableItem *item = new TQComboTableItem(levelsTable, m_def.codeList(), true);
    levelsTable->setItem(i, 0, item);
    levelsTable->clearSelection();
    levelsTable->selectCells(i, 0, i, 0);
    levelsTable->setCurrentCell(i, 0);
    addBtn->setEnabled(false);
    slotChanged();
    
    kdDebug()<<k_funcinfo<<"Added row="<<i<<" level="<<level->value()<<endl;
}

void WBSDefinitionPanel::slotLevelChanged(int value) {
    for (int i=0; i < levelsTable->numRows(); ++i) {
        if (value == levelsTable->verticalHeader()->label(i).toInt()) {
            addBtn->setEnabled(false);
            return;
        }
    }
    addBtn->setEnabled(levelsGroup->isChecked());
    slotChanged();
}
void WBSDefinitionPanel::slotLevelsGroupToggled(bool /*on*/) {
    slotLevelChanged(level->value());
}


}  //KPlato namespace

#include "kptwbsdefinitionpanel.moc"
