/* This file is part of the KDE project
   Copyright (C) 2004 Brad Hards <bradh@frogmouth.net>
   Based heavily on webpresentation.h, which is:
     Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef mspresentation_h
#define mspresentation_h

#include <kwizard.h>

#include <tqdialog.h>
#include <tqvaluelist.h>


class KPrDocument;
class KPrView;

class KURLRequester;
class KColorButton;
class TDEListView;
class KIntNumInput;
class KLineEdit;
class KComboBox;

class TQVBox;
class TQHBox;

class TQListViewItem;
class TQCloseEvent;
class KProgress;
class TQLabel;
class TQGroupBox;
class TQVBoxLayout;

class KPrMSPresentation
{
public:

    KPrMSPresentation( KPrDocument *_doc, KPrView *_view );
    KPrMSPresentation( const KPrMSPresentation &msPres );

    void setTitle( const TQString &_title )
        { title = _title; }
    void setBackColour( const TQColor &_backColour )
        { backColour = _backColour; }
    void setTextColour( const TQColor &_textColour )
        { textColour = _textColour; }
    void setPath( const TQString &_path )
        { path = _path; }

    TQString getTitle() const { return title; }
    TQColor getBackColour() const { return backColour; }
    TQColor getTextColour() const { return textColour; }
    TQString getPath() const { return path; }

    struct SlideInfo {
        int pageNumber; /* 0-based */
    };
    TQValueList<SlideInfo> getSlideInfos() const { return slideInfos; }

    int initSteps() const { return 7; }
    int slidesSteps() { return slideInfos.count(); }
    int indexFileSteps() const { return 4 + slideInfos.count(); }

    void initCreation( KProgress *progressBar );
    void createSlidesPictures( KProgress *progressBar );
    void createIndexFile( KProgress *progressBar );

protected:
    void init();

    KPrDocument *doc;
    KPrView *view;

    TQString title;
    TQValueList<SlideInfo> slideInfos;
    TQColor backColour, textColour;
    TQString path;
    TQString slidePath; // directory relative to path, containing slides 

};

class KPrMSPresentationSetup : public TQDialog
{
    Q_OBJECT
  

public:
    KPrMSPresentationSetup( KPrDocument *_doc, KPrView *_view );
    ~KPrMSPresentationSetup();

    static void createMSPresentation( KPrDocument *_doc, KPrView *_view );

protected:
    KPrDocument *doc;
    KPrView *view;
    KPrMSPresentation msPres;

    KLineEdit *title;
    KColorButton *textColour, *backColour;
    TQGroupBox *colourGroup;
    TQVBoxLayout *mainLayout;
    KURLRequester *path;

protected slots:
    void slotChoosePath(const TQString &);
    virtual void finish();
    virtual void helpMe();
    void showColourGroup(bool on);
};

class KPrMSPresentationCreateDialog : public TQDialog
{
    Q_OBJECT
  

public:
    KPrMSPresentationCreateDialog( KPrDocument *_doc, KPrView *_view, const KPrMSPresentation &_msPres );
    ~KPrMSPresentationCreateDialog();

    static void createMSPresentation( KPrDocument *_doc, KPrView *_view, const KPrMSPresentation &_msPres );

    void start();

    void initCreation();
    void createSlidesPictures();
    void createIndexFile();

protected:
    void setupGUI();
    void resizeEvent( TQResizeEvent *e );

    KPrView *view;
    KPrDocument *doc;
    KPrMSPresentation msPres;

    KProgress *progressBar;
    TQLabel *step1, *step2, *step3;
    TQPushButton *bDone;
    TQVBox *back;

};
#endif

