/* This file is part of the KDE project
   Copyright (C) 1998, 1999, 2000 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef TOOLBOX_H
#define TOOLBOX_H

#include <tqframe.h>
#include <tqpoint.h>
#include <koffice_export.h>
class TQVBoxLayout;
class TQSpinBox;

class KoDocumentChild;

namespace KSpread
{

class KOFFICEUI_EXPORT ToolBox : public TQFrame
{
    Q_OBJECT
  
public:
    ToolBox( TQWidget* parent = 0, const char* name = 0 );

public slots:
    void setEnabled( bool enable );

protected:
    // void paintEvent( TQPaintEvent* );
    void childEvent( TQChildEvent* ev );
    void mousePressEvent( TQMouseEvent* ev );
    void mouseMoveEvent( TQMouseEvent* ev );

private:
    TQVBoxLayout* m_layout;
    TQPoint m_mousePos;
    TQPoint m_startPos;
};

class KOFFICEUI_EXPORT KoTransformToolBox : public ToolBox
{
    Q_OBJECT
  
public:
    KoTransformToolBox( KoDocumentChild* child, TQWidget* parent = 0, const char* name = 0 );

    double rotation() const;
    double scaling() const;
    double xShearing() const;
    double yShearing() const;

    void setRotation( double );
    void setScaling( double );
    void setXShearing( double );
    void setYShearing( double );

signals:
    void rotationChanged( double );
    void scalingChanged( double );
    void xShearingChanged( double );
    void yShearingChanged( double );

public slots:
    void setDocumentChild( KoDocumentChild* );

private slots:
    void slotRotationChanged( int );
    void slotScalingChanged( int );
    void slotXShearingChanged( int );
    void slotYShearingChanged( int );

private:
    TQSpinBox* m_rotation;
    TQSpinBox* m_scale;
    TQSpinBox* m_shearX;
    TQSpinBox* m_shearY;
    KoDocumentChild* m_child;
    class Private;
    Private *d;
};

} // namespace KSpread

#endif
