/* This file is part of the KDE project
  
   Copyright (C) 2002 Joseph Wenninger <jowenn@kde.org>

   Large parts are taken from tdebase/konqueror/konq_actions.*  
   Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _MAILMERGE_ACTIONS_
#define _MAILMERGE_ACTIONS_

#include <tdeaction.h>
#include <tqtoolbutton.h>

class KWMailMergeLabelAction : public TDEAction
{
  Q_OBJECT
  
public:
  KWMailMergeLabelAction( const TQString &text, int accel,
                    TQObject* receiver, const char* slot, TQObject *parent = 0, const char *name = 0 );

  virtual int plug( TQWidget *widget, int index = -1 );
  virtual void unplug( TQWidget *widget );
  TQToolButton * label() { return m_label; }
private:
  TQToolButton * m_label;
};

#endif
