/* This file is part of the KDE project
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _SERIALLETTER_QtSql_BASE_H_
#define _SERIALLETTER_QtSql_BASE_H_

#include <tqdom.h>
#include <kdialogbase.h>
#include <tqsqldatabase.h>
#include <tqguardedptr.h>

#include "KWMailMergeDataSource.h"
#include "qtsqlopenwidget.h"



/******************************************************************
 *
 * Class: KWQtSqlSerialDataSourceBase
 *
 ******************************************************************/
class KWQtSqlSerialDataSourceBase: public KWMailMergeDataSource
{
    Q_OBJECT
//    
    K_DCOP
    public:
    KWQtSqlSerialDataSourceBase(TDEInstance *inst,TQObject *parent);
    ~KWQtSqlSerialDataSourceBase();

   virtual bool showConfigDialog(TQWidget *par,int action);

    protected:
	friend class KWQtSqlMailMergeOpen;
	TQString hostname;
	TQString username;
	TQString driver;
	TQString port;
	TQString databasename;
	TQGuardedPtr<TQSqlDatabase> database;
	TQString DataBaseConnection;
        static int connectionId;
   k_dcop:
     bool openDatabase();

};

#endif
