/* This file is part of the KDE libraries
    Copyright (C) 2000 Reginald Stadlbauer <reggie@kde.org>
    Copyright (C) 2002 Werner Trobin <trobin@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef kcoloractions_h
#define kcoloractions_h

#include <tdeaction.h>

/**
 * An action whose pixmap is automatically generated from a color.
 * It knows three types of pixmaps: text color, frame color and background color
 */
class KColorAction : public TDEAction
{
    Q_OBJECT
  

public:
    enum Type {
	TextColor,
	FrameColor,
	BackgroundColor
    };

    // Create default (text) color action
    KColorAction( const TQString& text, int accel = 0, TQObject* parent = 0, const char* name = 0 );
    KColorAction( const TQString& text, int accel,
		  TQObject* receiver, const char* slot, TQObject* parent, const char* name = 0 );
    KColorAction( TQObject* parent = 0, const char* name = 0 );

    // Create a color action of a given type
    KColorAction( const TQString& text, Type type, int accel = 0,
		  TQObject* parent = 0, const char* name = 0 );
    KColorAction( const TQString& text, Type type, int accel,
		  TQObject* receiver, const char* slot, TQObject* parent, const char* name = 0 );

    virtual void setColor( const TQColor &c );
    TQColor color() const;

    virtual void setType( Type type );
    Type type() const;

private:
    void init();
    void createPixmap();

    TQColor col;
    Type typ;
};


class TDESelectColorAction : public TDEAction
{
    Q_OBJECT
  
public:
    enum Type {
        TextColor,
        LineColor,
        FillColor
    };

    TDESelectColorAction( const TQString& text, Type type,
                        const TQObject* receiver, const char* slot,
                        TDEActionCollection* parent, const char* name );
    virtual ~TDESelectColorAction();

    virtual int plug( TQWidget* w, int index = -1 );

    TQColor color() const;
    Type type() const;

public slots:
    virtual void setColor( const TQColor &c );
    virtual void setType( Type t );

signals:
    void colorSelected( const TQColor& color );

private:
    TQString whatsThisWithIcon() const; // duplicated, as it's private in tdeaction

    Type m_type;
    TQColor m_color;
};

#endif
