/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000 theKompany.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef TTDEACTION_H
#define TTDEACTION_H

#include <tdeaction.h>
#include <tqstringlist.h>
#include <koffice_export.h>
namespace TK {
  enum IconMode { IconOnly, IconAndText, TextOnly };
}

class TTDEToolBarButton;
class TKComboBox;

class KOFFICEUI_EXPORT TTDEAction : public TDEAction
{ Q_OBJECT
  
public:
  TTDEAction(TQObject* parent, const char* name);
  ~TTDEAction();

  virtual int plug(TQWidget* widget, int index = -1);

  TK::IconMode iconMode();

protected:
  virtual void initToolBarButton(TTDEToolBarButton*);

  TQWidget* createLayout(TQWidget* parent, TQWidget* children);
  void updateLayout();
  virtual void updateLayout(TQWidget*);

public slots:
  virtual void setIconMode(TK::IconMode);
  void setText(const TQString&);
  void setIcon(const TQString&);

private:
  TK::IconMode m_imode;
  class TTDEActionPrivate;
  TTDEActionPrivate *d;
};
/******************************************************************************/
class KOFFICEUI_EXPORT TKBaseSelectAction : public TTDEAction
{ Q_OBJECT
  
friend class TTDESelectAction;
public:
  TKBaseSelectAction(TQObject* parent, const char* name);
  ~TKBaseSelectAction();

  virtual int plug(TQWidget* widget, int index = -1);

  int currentItem();
  bool isEditable();

  void activate(int);

protected:
  virtual void initComboBox(TKComboBox*);

public slots:
  virtual void setCurrentItem(int index);
  virtual void setEditable(bool);

protected slots:
  virtual void slotActivated(int);

signals:
  void activated(int);

private:
  int m_current;
  bool m_editable;
  class TKBaseSelectActionPrivate;
  TKBaseSelectActionPrivate *d;
};
/******************************************************************************/
class KOFFICEUI_EXPORT TTDESelectAction : public TKBaseSelectAction
{ Q_OBJECT
  
public:
  TTDESelectAction(TQObject* parent, const char* name);
  ~TTDESelectAction();

  TQStringList items() const;

public slots:
  virtual void setItems(const TQStringList& );
  virtual void setEditText(const TQString&);
  virtual void clear();

protected:
  virtual void initComboBox(TKComboBox*);

protected slots:
  void slotActivated(const TQString&);

signals:
  void activated(const TQString&);

private:
  TQStringList m_list;
  class TTDESelectActionPrivate;
  TTDESelectActionPrivate *d;
};
/******************************************************************************/
#endif
