/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KOVARIABLEDLGS_H
#define KOVARIABLEDLGS_H

#include "KoVariable.h"

#include <kdialogbase.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tdelistview.h>
#include <koffice_export.h>
class TQComboBox;
class TQVBox;
class TQResizeEvent;
class KLineEdit;
class TQCloseEvent;

/******************************************************************
 *
 * Class: KoVariableNameDia
 *
 ******************************************************************/

class KoVariableNameDia : public KDialogBase
{
    Q_OBJECT
  

public:
    // For KWMailMergeVariableInsertDia
    KoVariableNameDia( TQWidget *parent );
    // For kwview
    KoVariableNameDia( TQWidget *parent, const TQPtrList<KoVariable> &vars );
    TQString getName() const;

protected slots:
    void textChanged ( const TQString &_text );
protected:
    void init();

    TQComboBox *names;
    TQVBox *back;
};

/**
 * Class: KoCustomVariablesListItem
 * Used by KoCustomVariablesDia
 * Represents an item in the listview, holding a lineedit to edit the value of the variable.
 */
class KoCustomVariablesListItem : public TQListViewItem
{
public:
    KoCustomVariablesListItem( TQListView *parent );

    void setVariable( KoCustomVariable *v );
    KoCustomVariable *getVariable() const;

    virtual void setup();
    virtual int width ( const TQFontMetrics & fm, const TQListView * lv, int c ) const;
    void update();

    // Gets the value from the lineedit and sets it into the variable
    void applyValue();

protected:
    KoCustomVariable *var;
    KLineEdit *editWidget;
};

/**
 * Class: KoCustomVariablesList
 * The listview.
 * Used by KoCustomVariablesDia
 */
class KoCustomVariablesList : public TDEListView
{
    Q_OBJECT
  

public:
    KoCustomVariablesList( TQWidget *parent );

    void setValues();
    void updateItems();

protected slots:
    void columnSizeChange( int c, int os, int ns );
    void sectionClicked( int c );

private:
    class Private;
    Private* d; // currently unused
};

/**
 * Class: KoCustomVariablesDia
 * This dialog allows to set the value of the custom variables.
 */
class KOTEXT_EXPORT KoCustomVariablesDia : public KDialogBase
{
    Q_OBJECT
  

public:
    KoCustomVariablesDia( TQWidget *parent, const TQPtrList<KoVariable> &variables );
protected slots:
    void slotOk();

protected:
    TQVBox *back;
    KoCustomVariablesList *list;

};

/**
 * Class: KoCustomVarDialog
 * This dialog allows to add a new custom variable or
 * to edit an existing one.
 */
class KOTEXT_EXPORT KoCustomVarDialog : public KDialogBase
{
    Q_OBJECT
  

public:
    /**
     * Add new variable
     */
    KoCustomVarDialog( TQWidget *parent );
    /**
     * Edit existing variable @p var
     */
    KoCustomVarDialog( TQWidget *parent, KoCustomVariable *var );

    virtual TQString name();
    virtual TQString value();

protected slots:
    void slotAddOk();
    void slotEditOk();
    void slotTextChanged(const TQString&);

protected:
    TQVBox *back;
    KLineEdit *m_name;
    KLineEdit *m_value;

private:
    void init();
    KoCustomVariable *m_var;
};

#endif
