/* This file is part of the KDE project
   Copyright (C)  2001, 2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KoHighlightingTab.h"
#include "KoTextFormat.h"

#include <tqstringlist.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>

#include <kcombobox.h>
#include <kcolorbutton.h>

#include "KoHighlightingTab.moc"


KoHighlightingTab::KoHighlightingTab( TQWidget* parent, const char* name, WFlags fl ) 
        : KoHighlightingTabBase( parent, name, fl )
{
    underlineStyleKComboBox->insertStringList( KoTextFormat::underlineTypeList() );
    underlineLineStyleKComboBox->insertStringList( KoTextFormat::underlineStyleList() );
    strikethroughStyleKComboBox->insertStringList( KoTextFormat::strikeOutTypeList() );
    strikethroughLineStyleKComboBox->insertStringList( KoTextFormat::strikeOutStyleList() );

    capitalisationButtonGroup->setColumnLayout( 3, Qt::Horizontal );
    TQStringList attributes = KoTextFormat::fontAttributeList();
    for ( TQStringList::Iterator it = attributes.begin(); it != attributes.end(); ++it ) {
        capitalisationButtonGroup->insert( new TQRadioButton( *it, capitalisationButtonGroup ) );
    }
    capitalisationButtonGroup->setButton( 0 );

    connect( underlineStyleKComboBox, TQT_SIGNAL( activated( int ) ), this, TQT_SLOT( slotUnderlineChanged( int ) ) );
    connect( underlineLineStyleKComboBox, TQT_SIGNAL( activated( int ) ), this, TQT_SIGNAL( underlineStyleChanged( int ) ) );
    connect( underlineKColorButton, TQT_SIGNAL( changed( const TQColor & ) ), this, TQT_SIGNAL( underlineColorChanged( const TQColor & ) ) );
    connect( strikethroughStyleKComboBox, TQT_SIGNAL( activated( int ) ), this, TQT_SLOT( slotStrikethroughChanged( int ) ) );
    connect( strikethroughLineStyleKComboBox, TQT_SIGNAL( activated( int ) ), this, TQT_SIGNAL( strikethroughStyleChanged( int ) ) );
    connect( underlineWordByWordCheckBox, TQT_SIGNAL( toggled( bool ) ), this, TQT_SIGNAL( wordByWordChanged( bool ) ) );
    connect( capitalisationButtonGroup, TQT_SIGNAL( clicked( int ) ), this, TQT_SIGNAL( capitalisationChanged( int ) ) );
}

KoHighlightingTab::~KoHighlightingTab()
{
}

KoTextFormat::UnderlineType KoHighlightingTab::getUnderline() const
{
    return static_cast<KoTextFormat::UnderlineType>( underlineStyleKComboBox->currentItem() );
}

KoTextFormat::UnderlineStyle KoHighlightingTab::getUnderlineStyle() const
{
    return static_cast<KoTextFormat::UnderlineStyle>( underlineLineStyleKComboBox->currentItem() );
}

TQColor KoHighlightingTab::getUnderlineColor() const
{
    return underlineKColorButton->color();
}

KoTextFormat::StrikeOutType KoHighlightingTab::getStrikethrough() const
{
    return static_cast<KoTextFormat::StrikeOutType>( strikethroughStyleKComboBox->currentItem() );
}

KoTextFormat::StrikeOutStyle KoHighlightingTab::getStrikethroughStyle() const
{
    return static_cast<KoTextFormat::StrikeOutStyle>( strikethroughLineStyleKComboBox->currentItem() );
}

bool KoHighlightingTab::getWordByWord() const
{
    return underlineWordByWordCheckBox->isOn();
}

KoTextFormat::AttributeStyle KoHighlightingTab::getCapitalisation() const
{
    return static_cast<KoTextFormat::AttributeStyle>( capitalisationButtonGroup->selectedId() );
}

void KoHighlightingTab::setUnderline( KoTextFormat::UnderlineType item )
{
    underlineStyleKComboBox->setCurrentItem( static_cast<int>( item ) );
    slotUnderlineChanged( static_cast<int>( item ) );
}

void KoHighlightingTab::setUnderlineStyle( KoTextFormat::UnderlineStyle item )
{
    underlineLineStyleKComboBox->setCurrentItem( static_cast<int>( item ) );
    emit underlineStyleChanged( static_cast<int>( item ) );
}

void KoHighlightingTab::setUnderlineColor( const TQColor &color )
{
    underlineKColorButton->setColor( color );
}

void KoHighlightingTab::setStrikethrough( int item )
{
    strikethroughStyleKComboBox->setCurrentItem( static_cast<int>( item ) );
    slotStrikethroughChanged( static_cast<int>( item ) );
}

void KoHighlightingTab::setStrikethroughStyle( int item )
{
    strikethroughLineStyleKComboBox->setCurrentItem( static_cast<int>( item ) );
    emit strikethroughStyleChanged( static_cast<int>( item ) );
}

void KoHighlightingTab::setWordByWord( bool state )
{
    underlineWordByWordCheckBox->setChecked( state );
}

void KoHighlightingTab::setCapitalisation( int item )
{
    capitalisationButtonGroup->setButton( static_cast<int>( item ) );
    emit capitalisationChanged( static_cast<int>( item ) );
}

void KoHighlightingTab::slotUnderlineChanged( int item )
{
    underlineLineStyleKComboBox->setEnabled( item > 0 );
    underlineKColorButton->setEnabled( item > 0 );
    underlineWordByWordCheckBox->setEnabled( ( item > 0 ) || ( strikethroughStyleKComboBox->currentItem() > 0 ) );
    emit underlineChanged( item );
}

void KoHighlightingTab::slotStrikethroughChanged( int item )
{
    strikethroughLineStyleKComboBox->setEnabled( item > 0 );
    underlineWordByWordCheckBox->setEnabled( ( item > 0 ) || ( underlineStyleKComboBox->currentItem() > 0 ) );
    emit strikethroughChanged(  item );
}

