/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef kostylist_h
#define kostylist_h

#include <kdialogbase.h>
#include <tqstringlist.h>

#include <KoParagDia.h>
#include <KoFontTab.h>
#include <KoDecorationTab.h>
#include <KoHighlightingTab.h>
#include <KoLayoutTab.h>
#include <KoLanguageTab.h>
#include <KoUnit.h>
#include <tqptrlist.h>
#include <KoStyleCollection.h>

//class KoFontChooser;
class KoParagStyle;
class KoStyleEditor;
class KoStyleManagerTab;
class TQCheckBox;
class TQComboBox;
class TQGridLayout;
class TQLineEdit;
class TQListBox;
class TQPushButton;
class TQTabWidget;
class TQWidget;
class KoTextDocument;
class KoStyleManagerPrivate;

/**
 * This class provides a dialog for editing named text styles.
 */
class KOTEXT_EXPORT KoStyleManager : public KDialogBase
{
    Q_OBJECT
  

public:
    enum { ShowIncludeInToc = 1 }; // bitfield for flags
    KoStyleManager( TQWidget *_parent, KoUnit::Unit unit,
                    const KoStyleCollection& styleCollection,
                    const TQString & activeStyleName,
                    int flags = 0 );
    virtual ~KoStyleManager();

    virtual KoParagStyle* addStyleTemplate(KoParagStyle *style)=0;
    //virtual void applyStyleChange( KoParagStyle * changedStyle, int paragLayoutChanged, int formatChanged )=0;
    virtual void applyStyleChange( KoStyleChangeDefMap changed )=0;

    virtual void removeStyleTemplate( KoParagStyle *style )=0;
    virtual void updateAllStyleLists()=0;
    virtual void updateStyleListOrder( const TQStringList & list)=0;

protected:
    void updateFollowingStyle( KoParagStyle *s );
    void updateInheritStyle( KoParagStyle *s );
    void setupWidget(const KoStyleCollection & styleCollection);
    void addGeneralTab( int flags );
    void apply();
    void updateGUI();
    void updatePreview();
    void save();
    int styleIndex( int pos );

private:
    TQTabWidget *m_tabs;
    TQListBox *m_stylesList;
    TQLineEdit *m_nameString;
    TQComboBox *m_styleCombo;
    TQPushButton *m_deleteButton;
    TQPushButton *m_newButton;
    TQPushButton *m_moveUpButton;
    TQPushButton *m_moveDownButton;
    TQComboBox *m_inheritCombo;
    KoStyleManagerPrivate *d;

    KoParagStyle *m_currentStyle;
    TQPtrList<KoParagStyle> m_origStyles;      // internal list of orig styles we have modified
    TQPtrList<KoParagStyle> m_changedStyles;   // internal list of changed styles.
    TQPtrList<KoStyleManagerTab> m_tabsList;
    TQStringList m_styleOrder;
    int numStyles;
    bool noSignals;

protected slots:
    virtual void slotOk();
    virtual void slotApply();
    void switchStyle();
    void switchTabs();
    void addStyle();
    void deleteStyle();
    void moveUpStyle();
    void moveDownStyle();
    void renameStyle(const TQString &);
protected:
    KoParagStyle * style( const TQString & _name );
    void addTab( KoStyleManagerTab * tab );
    TQString generateUniqueName();
};

class KOTEXT_EXPORT KoStyleManagerTab : public TQWidget {
    Q_OBJECT
  
public:
    KoStyleManagerTab(TQWidget *parent) : TQWidget(parent) {};

    /** the new style which is to be displayed */
    void setStyle(KoParagStyle *style) { m_style = style; }
    /**  update the GUI from the current Style*/
    virtual void update() = 0;
    /**  return the (i18n-ed) name of the tab */
    virtual TQString tabName() = 0;
    /** save the GUI to the style */
    virtual void save() = 0;
protected:
    KoParagStyle *m_style;
};

// A tab to edit parts of the parag-layout of the style
// Acts as a wrapper around KoParagLayoutWidget [which doesn't know about styles].
class KOTEXT_EXPORT KoStyleParagTab : public KoStyleManagerTab
{
    Q_OBJECT
  
public:
    KoStyleParagTab( TQWidget * parent );

    // not a constructor parameter since 'this' is the parent of the widget
    void setWidget( KoParagLayoutWidget * widget );

    virtual void update();
    virtual void save();
    virtual TQString tabName() { return m_widget->tabName(); }
protected:
    virtual void resizeEvent( TQResizeEvent *e );
private:
    KoParagLayoutWidget * m_widget;
};

// The "font" tab. Maybe we should put the text color at the bottom ?
class KOTEXT_EXPORT KoStyleFontTab : public KoStyleManagerTab
{
    Q_OBJECT
  
public:
    KoStyleFontTab( TQWidget * parent );
    ~KoStyleFontTab();
    virtual void update();
    virtual TQString tabName();
    virtual void save();
private:
	KoFontTab *m_fontTab;
	KoDecorationTab *m_decorationTab;
	KoHighlightingTab *m_highlightingTab;
	KoLayoutTab *m_layoutTab;
	KoLanguageTab *m_languageTab;
};

/*
Font            simple font dia
Color           simple color dia
Spacing and Indents     paragraph spacing dia (KWParagDia)
alignments      KoParagDia alignment tab
borders         KoParagDia  borders tab
numbering       KoParagDia  tab numbering
tabulators      KoParagDia  tab tabs */

#endif
