/* This file is part of the KDE project
   Copyright (C) 2005 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004-2005 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KexiDBDoubleSpinBox_H
#define KexiDBDoubleSpinBox_H

#include "kexiformdataiteminterface.h"
#include <tqwidget.h>
#include <knuminput.h>

//! @short A db-aware int spin box
class KEXIFORMUTILS_EXPORT KexiDBDoubleSpinBox : public KDoubleSpinBox, public KexiFormDataItemInterface
{
	TQ_OBJECT
  
	TQ_PROPERTY(TQString dataSource READ dataSource WRITE setDataSource DESIGNABLE true)
	TQ_PROPERTY(TQCString dataSourceMimeType READ dataSourceMimeType WRITE setDataSourceMimeType DESIGNABLE true)
	TQ_PROPERTY( bool readOnly READ isReadOnly WRITE setReadOnly DESIGNABLE true )

	public:
		KexiDBDoubleSpinBox(TQWidget *parent, const char *name=0);
		virtual ~KexiDBDoubleSpinBox();

		inline TQString dataSource() const { return KexiFormDataItemInterface::dataSource(); }
		inline TQCString dataSourceMimeType() const { return KexiFormDataItemInterface::dataSourceMimeType(); }
		virtual TQVariant value();
		virtual void setInvalidState( const TQString& displayText );

		//! \return true if editor's value is null (not empty)
		//! Used for checking if a given constraint within table of form is met.
		virtual bool valueIsNull();

		//! \return true if editor's value is empty (not necessary null).
		//! Only few data types can accept "EMPTY" property
		//! (use KexiDB::Field::hasEmptyProperty() to check this).
		//! Used for checking if a given constraint within table or form is met.
		virtual bool valueIsEmpty();

		/*! \return 'readOnly' flag for this widget.  */
		virtual bool isReadOnly() const;

		/*! \return the view widget of this item, e.g. line edit widget. */
		virtual TQWidget* widget();

		virtual bool cursorAtStart();
		virtual bool cursorAtEnd();
		virtual void clear();

	public slots:
		virtual void setEnabled(bool enabled);
		inline void setDataSource(const TQString &ds) { KexiFormDataItemInterface::setDataSource(ds); }
		inline void setDataSourceMimeType(const TQCString &ds) { KexiFormDataItemInterface::setDataSourceMimeType(ds); }
		void slotValueChanged();
		virtual void setReadOnly(bool set);

	protected:
		virtual void setValueInternal(const TQVariant& add, bool removeOld);

	private:
		bool m_invalidState : 1;
};

#endif
