/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  begin:     Mit Aug 7 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/
// Copyright (C) 2004-2007 Shintaro Matsuoka <shin@shoegazed.org>

#ifndef DCCTRANSFERPANEL_H
#define DCCTRANSFERPANEL_H

#include "chatwindow.h"
#include "dcctransferpanelitem.h"


class TQContextMenuEvent;
class TQPushButton;
class TDEListView;
class TDEPopupMenu;

class DccTransferDetailedInfoPanel;

class DccTransferPanel : public ChatWindow
{
    Q_OBJECT
  

        public:
        class Column
        {
            public:
                enum Object
                {
                    TypeIcon,
                    OfferDate,
                    Status,
                    FileName,
                    PartnerNick,
                    Progress,
                    Position,
                    TimeLeft,
                    CurrentSpeed,
                    SenderAddress,
                    COUNT
                };
        };

        class Popup
        {
            public:
                enum Object
                {
                    SelectAll,
                    SelectAllCompleted,
                    Accept,
                    Abort,
                    Clear,
                    Open,
                    Info,
                    Resend
                };
        };

        DccTransferPanel(TQWidget* parent);
        ~DccTransferPanel();

        TDEListView* getListView();

    protected slots:
        void slotNewTransferAdded( DccTransfer* transfer );
        void slotTransferStatusChanged();

        void acceptDcc();
        void abortDcc();
        void resendFile();
        void clearDcc();
        void runDcc();
        void showFileInfo();
        void selectAll();
        void selectAllCompleted();

        void popupRequested(TQListViewItem* item,const TQPoint& pos,int col);
        void popupActivated(int id);

        void doubleClicked(TQListViewItem* _item,const TQPoint& _pos,int _col);

        void updateButton();

        void setDetailPanelItem(TQListViewItem* item_);

    protected:
        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        void initGUI();

        TDEListView* m_listView;
        TDEPopupMenu* m_popup;

        DccTransferDetailedInfoPanel* m_detailPanel;

        TQPushButton* m_buttonAccept;
        TQPushButton* m_buttonAbort;
        TQPushButton* m_buttonClear;
        TQPushButton* m_buttonOpen;
        TQPushButton* m_buttonDetail;
};
#endif
