/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  The line input widget with chat enhanced functions
  begin:     Tue Mar 5 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef IRCINPUT_H
#define IRCINPUT_H

#include <tqstringlist.h>

#include <ktextedit.h>


class TDECompletionBox;
class TQMouseEvent;

class IRCInput : public KTextEdit
{
    Q_OBJECT
  

    public:
        explicit IRCInput(TQWidget* parent);
        ~IRCInput();

        void setCompletionMode(char mode);
        char getCompletionMode();
        void setOldCursorPosition(int pos);
        int getOldCursorPosition();
        TQString lastCompletion() const { return m_lastCompletion; }

        virtual TQSize sizeHint() const;
        TQString text() const;

    signals:
        void nickCompletion();
        void endCompletion();                     // tell channel that completion phase is over
        void history(bool up);
        void textPasted(const TQString& text);
        void submit();
        void envelopeCommand();

    public slots:
        void paste();
        void paste(bool useSelection);
        void showCompletionList(const TQStringList& nicks);
        void setText(const TQString& text);
        void setLastCompletion(const TQString& completion);
        virtual void setOverwriteMode(bool) { }
        virtual void resizeContents( int w, int h );
        virtual void updateAppearance();

    protected slots:
        void getHistory(bool up);
        void insertCompletion(const TQString& nick);
        void disableSpellChecking();
        virtual void slotSpellCheckDone(const TQString& s);

    protected:
        bool eventFilter(TQObject *object,TQEvent *event);
        void addHistory(const TQString& text);
        bool checkPaste(TQString& text);
        void contentsMouseReleaseEvent(TQMouseEvent *);

        virtual void keyPressEvent(TQKeyEvent* e);
        virtual TQPopupMenu *createPopupMenu( const TQPoint& pos );
        virtual void showEvent(TQShowEvent* e);
        virtual void hideEvent(TQHideEvent* e);

        TQStringList historyList;
        unsigned int lineNum;
        unsigned int oldPos;
        char completionMode;
        TDECompletionBox* completionBox;
        TQString m_lastCompletion;
        bool m_useSelection;
        bool m_multiRow;
        int m_lastHeight; //essentially corresponds to qtextbrowser::doc->height()
        int m_qtBoxPadding; //see comment in constructor

        TQTimer* m_disableSpellCheckTimer;
};
#endif
