/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  copyright: (C) 2004 by Peter Simonsson
  email:     psn@linux.se
*/
#ifndef KONVERSATIONNOTIFICATIONHANDLER_H
#define KONVERSATIONNOTIFICATIONHANDLER_H

#include <tqobject.h>


class ChatWindow;
class KonversationApplication;
class KonversationMainWindow;

namespace Konversation
{

    class NotificationHandler : public TQObject
    {
        Q_OBJECT
  

        public:
            explicit NotificationHandler(KonversationApplication* parent = 0, const char* name = 0);
            ~NotificationHandler();

        public slots:
            void message(ChatWindow* chatWin, const TQString& fromNick, const TQString& message);
            void nick(ChatWindow* chatWin, const TQString& fromNick, const TQString& message);
            void join(ChatWindow* chatWin, const TQString& nick);
            void part(ChatWindow* chatWin, const TQString& nick);
            void quit(ChatWindow* chatWin, const TQString& nick);
            void nickChange(ChatWindow* chatWin, const TQString& oldNick, const TQString& newNick);
            void dccIncoming(ChatWindow* chatWin, const TQString& fromNick);
            void mode(ChatWindow* chatWin, const TQString& nick);
            void query(ChatWindow* chatWin, const TQString& fromNick);
            void queryMessage(ChatWindow* chatWin, const TQString& fromNick, const TQString& message);
            void nickOnline(ChatWindow* chatWin, const TQString& nick);
            void nickOffline(ChatWindow* chatWin, const TQString& nick);
            void kick(ChatWindow* chatWin, const TQString& channel,const TQString& nick);
            void dccChat(ChatWindow* chatWin, const TQString& nick);
            void highlight(ChatWindow* chatWin, const TQString& fromNick, const TQString& message);
            void connectionFailure(ChatWindow* chatWin, const TQString& server);
            void channelJoin(ChatWindow* chatWin, const TQString& channel);

        protected:
            void startTrayNotification(ChatWindow* chatWin);
            TQString addLineBreaks(const TQString& string);

        private:
            KonversationMainWindow* m_mainWindow;
    };

}
#endif
