/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2006 John Tapsell <johnflux@gmail.com>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/


#include "warnings_preferences.h"
#include "konviconfigdialog.h"

#include <tqlistview.h>

#include <kdebug.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdelistview.h>


Warnings_Config::Warnings_Config( TQWidget* parent, const char* name, WFlags fl )
    : Warnings_ConfigUI( parent, name, fl )
{
  dialogListView->setSorting(1);
  loadSettings();
  connect(dialogListView, TQT_SIGNAL(clicked(TQListViewItem *)), this, TQT_SIGNAL(modified()));
}

Warnings_Config::~Warnings_Config()
{
}

void Warnings_Config::restorePageToDefaults()
{
  
  TQCheckListItem* item=static_cast<TQCheckListItem*>(dialogListView->itemAtIndex(0));
  bool changed=false;
  while(item)
  {
    if(!item->isOn()) {
      item->setOn(true);
      changed=true;
    }
    item=static_cast<TQCheckListItem*>(item->itemBelow());
  }
  if(changed) {
    emit modified();
  }
}

void Warnings_Config::saveSettings()
{
  TDEConfig* config = kapp->config();
  config->setGroup("Notification Messages");

  // prepare list
  TQString warningsChecked;

  TQCheckListItem* item=static_cast<TQCheckListItem*>(dialogListView->itemAtIndex(0));
  int i = 0;
  while(item)
  {
    // save state of this item in hasChanged() list
    warningsChecked+=item->isOn();

    if (item->text(2) == "LargePaste" || item->text(2) == "Invitation")
    {
        if (item->isOn())
        {
            config->writeEntry(item->text(2), 1);
        }
        else
        {
            TQString state = config->readEntry(item->text(2));

            if (!state.isEmpty() && (state == "yes" || state == "no"))
                config->writeEntry(item->text(2), state);
            else
                config->writeEntry(item->text(2), "yes");
        }
    }
    else
    {
        config->writeEntry(item->text(2),item->isOn() ? "1" : "0");
    }

    item=static_cast<TQCheckListItem*>(item->itemBelow());
    ++i;
  }

  // remember checkbox state for hasChanged()
  m_oldWarningsChecked=warningsChecked;
}

void Warnings_Config::loadSettings()
{
  TQStringList dialogDefinitions;
  TQString flagNames = "Invitation,SaveLogfileNote,ClearLogfileQuestion,CloseQueryAfterIgnore,ReconnectWithDifferentServer,ReuseExistingConnection,QuitServerTab,QuitChannelTab,QuitQueryTab,ChannelListNoServerSelected,HideMenuBarWarning,ChannelListWarning,LargePaste,systemtrayquitKonversation,IgnoreNick,UnignoreNick,QuitWithActiveDccTransfers";
  dialogDefinitions.append(i18n("Automatically join channel on invite"));
  dialogDefinitions.append(i18n("Notice that saving logfiles will save whole file"));
  dialogDefinitions.append(i18n("Ask before deleting logfile contents"));
  dialogDefinitions.append(i18n("Ask about closing queries after ignoring the nickname"));
  dialogDefinitions.append(i18n("Ask before switching a connection to a network to a different server"));
  dialogDefinitions.append(i18n("Ask before creating another connection to the same network or server"));
  dialogDefinitions.append(i18n("Close server tab"));
  dialogDefinitions.append(i18n("Close channel tab"));
  dialogDefinitions.append(i18n("Close query tab"));
  dialogDefinitions.append(i18n("The channel list can only be opened from server-aware tabs"));
  dialogDefinitions.append(i18n("Warning on hiding the main window menu"));
  dialogDefinitions.append(i18n("Warning on high traffic with channel list"));
  dialogDefinitions.append(i18n("Warning on pasting large portions of text"));
  dialogDefinitions.append(i18n("Warning on quitting Konversation"));
  dialogDefinitions.append(i18n("Ignore"));
  dialogDefinitions.append(i18n("Unignore"));
  dialogDefinitions.append(i18n("Warn before quitting with active DCC file transfers"));
  TQCheckListItem *item;
  dialogListView->clear();

  TDEConfig* config = kapp->config();
  config->setGroup("Notification Messages");
  TQString flagName; 
  for(unsigned int i=0; i<dialogDefinitions.count() ;i++)
  {
    item=new TQCheckListItem(dialogListView,dialogDefinitions[i],TQCheckListItem::CheckBox);
    item->setText(1,dialogDefinitions[i]);
    flagName = flagNames.section(",",i,i);
    item->setText(2,flagName);

    if (flagName == "LargePaste" || flagName == "Invitation")
    {
        TQString state = config->readEntry(flagName);

        if (state == "yes" || state == "no")
            item->setOn(false);
        else
            item->setOn(true);
    }
    else
    {
        item->setOn(config->readBoolEntry(flagName,true));
    }
  }
  // remember checkbox state for hasChanged()
  m_oldWarningsChecked=currentWarningsChecked();
}

// get a list of checked/unchecked items for hasChanged()
TQString Warnings_Config::currentWarningsChecked()
{
  // prepare list
  TQString newList;

  // get first checklist item
  TQListViewItem* item=dialogListView->firstChild();
  while(item)
  {
    // save state of this item in hasChanged() list
    newList+=(static_cast<TQCheckListItem*>(item)->isOn()) ? "1" : "0";
    item=item->itemBelow();
  }
  // return list
  return newList;
}

bool Warnings_Config::hasChanged()
{
  return(m_oldWarningsChecked!=currentWarningsChecked());
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void Warnings_Config::languageChange()
{
  loadSettings();
}

#include "warnings_preferences.moc"
