/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti   *
 *   michael_zanetti@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SMPPOPUP_H
#define SMPPOPUP_H

#include "kopetechatsession.h"

#include "smppopupui.h"
#include "otrlchatinterface.h"

extern "C"{
#include "libotr/proto.h"
}

class SMPPopup : public SMPPopupUI
{
  Q_OBJECT

public:
  SMPPopup(TQWidget* parent = 0, const char* name = 0, TQString title = TQString::null, WFlags fl = 0, ConnContext *context = 0, Kopete::ChatSession *session = 0, bool initiate = true );
  ~SMPPopup();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          cancelSMP();
  virtual void          respondSMP();
  virtual void		openHelp();
  virtual void		manualAuth();

protected:
  /*$PROTECTED_FUNCTIONS$*/

	ConnContext *context;
	Kopete::ChatSession *session;
	bool initiate;
	bool question;

protected slots:
  /*$PROTECTED_SLOTS$*/

};

#endif
