/***************************************************************************
                          kplayerslideraction.h
                          ---------------------
    begin                : Sat Jan 11 2003
    copyright            : (C) 2003-2007 by kiriuja
    email                : http://kplayer.sourceforge.net/email.html
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KPLAYERSLIDERACTION_H
#define KPLAYERSLIDERACTION_H

#include <tdeaction.h>
#include <tqhbox.h>
#include <tqslider.h>

/**KPlayer's slider widget. Works around the TQt upside-down slider bug.
  *@author kiriuja
  */
class KPlayerSlider : public TQSlider
{
  Q_OBJECT

public:
  /** The KPlayerSlider constructor. Parameters are passed on to TQSlider. */
  KPlayerSlider (TQt::Orientation, TQWidget* parent = 0, const char* name = 0);
  /** The KPlayerSlider destructor. Does nothing. */
  virtual ~KPlayerSlider();

  /** The size hint. */
  virtual TQSize sizeHint() const;
  /** The minimum size hint. */
  virtual TQSize minimumSizeHint() const;

  /** The minimum value. */
  int minValue (void) const;
  /** Sets the minimum value. */
  void setMinValue (int);
  /** The maximum value. */
  int maxValue (void) const;
  /** Sets the maximum value. */
  void setMaxValue (int);
  /** The current value. */
  int value (void) const;
  /** Sets the current value. The extra parameter prevents overriding of the virtual TQSlider::setValue. */
  void setValue (int, int = 0); // do not override the virtual setValue

  /** Sets up the slider by setting all options in one go. */
  void setup (int minValue, int maxValue, int value, bool tickMarks, int tickInterval, int pageStep, int lineStep);
  /** Sets the slider orientation. */
  virtual void setOrientation (Orientation);

  /** Returns the dragging state. */
  bool dragging (void)
    { return m_dragging; }

signals:
  /** Emitted when the slider value changes. */
  void changed (int);

protected slots:
  /** Receives the valueChanged signal from TQSlider. */
  void sliderValueChanged (int);
  /** Keeps track of dragging state. */
  //void sliderThumbPressed (void);
  /** Keeps track of dragging state. */
  //void sliderThumbReleased (void);

protected:
  /** Filters keystrokes. */
  virtual void keyPressEvent (TQKeyEvent*);
  /** Remember mouse button state. */
  virtual void mousePressEvent (TQMouseEvent*);
  /** Remember mouse button state. */
  virtual void mouseReleaseEvent (TQMouseEvent*);
  /** Processes the wheel event. Reverses direction when the slider is horizontal. */
  virtual void wheelEvent (TQWheelEvent*);

  /** Dragging state. */
  bool m_dragging;

  // Recursion prevention. Should be private.
  bool m_changing_orientation;

  friend class KPlayerSliderAction;
  friend class KPlayerPopupSliderAction;
};

/**KPlayer popup frame.
  *@author kiriuja
  */
class KPlayerPopupFrame : public TQHBox
{
  Q_OBJECT

public:
  /** The KPlayerPopupFrame constructor. Parameters are passed on to TQHBox. */
  KPlayerPopupFrame (TQWidget* parent = 0, const char* name = 0)
    : TQHBox (parent, name, WType_Popup) { }
  /** The KPlayerPopupFrame destructor. Does nothing. */
  virtual ~KPlayerPopupFrame();

protected:
  /** Closes the popup frame when Alt, Tab, Esc, Enter or Return is pressed. */
  virtual void keyPressEvent (TQKeyEvent*);
};

/**Action representing a popup slider activated by a toolbar button.
  *@author kiriuja
  */
class KPlayerPopupSliderAction : public TDEAction
{
  Q_OBJECT

public:
  /** The KPlayerPopupSliderAction constructor. Parameters are passed on to TDEAction. */
  KPlayerPopupSliderAction (const TQString& text, const TQString& pix, const TDEShortcut& shortcut,
    const TQObject* receiver, const char* slot, TQObject* parent = 0, const char* name = 0);
  /** The KPlayerPopupSliderAction destructor. */
  virtual ~KPlayerPopupSliderAction();

  /** Returns a pointer to the KPlayerSlider object. */
  KPlayerSlider* slider (void)
    { return m_slider; }

protected slots:
  /** Pops up the slider. */
  virtual void slotActivated (void);

protected:
  /** The slider. */
  KPlayerSlider* m_slider;
  /** The popup frame. */
  KPlayerPopupFrame* m_frame;
};

/**Slider action suitable for insertion into a toolbar.
  *@author kiriuja
  */
class KPlayerSliderAction : public KWidgetAction
{
  Q_OBJECT

public:
  /** The KPlayerSliderAction constructor. Parameters are passed on to TDEAction. */
  KPlayerSliderAction (const TQString& text, const TDEShortcut&, const TQObject* receiver,
    const char* slot, TDEActionCollection* parent = 0, const char* name = 0);
  /** The KPlayerSliderAction destructor. */
  virtual ~KPlayerSliderAction();

  /** Returns a pointer to the KPlayerSlider object. */
  KPlayerSlider* slider (void)
    { return (KPlayerSlider*) widget(); }

  /** Plugs the slider into the toolbar. */
  virtual int plug (TQWidget* widget, int index = -1);
  /** Unplugs the slider from the toolbar. */
  virtual void unplug (TQWidget* widget);

protected slots:
  /** Changes the slider orientation when the toolbar orientation changes. */
  void orientationChanged (Orientation);
};

#endif
