/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

/**
@author Unai Garro
*/

#ifndef CREATEPROPERTYDIALOG_H
#define CREATEPROPERTYDIALOG_H

#include <ntqcombobox.h>
#include <ntqlayout.h>
#include <ntqpushbutton.h>
#include <ntqgroupbox.h>
#include <ntqvbox.h>
#include <ntqlabel.h>

#include <klineedit.h>
#include <kdialogbase.h>

#include "datablocks/unit.h"

class CreatePropertyDialog : public KDialogBase
{
public:
	CreatePropertyDialog( TQWidget *parent, UnitList *list );
	~CreatePropertyDialog();
	TQString newPropertyName( void );
	TQString newUnitsName( void );


private:
	//Widgets
	TQGroupBox *box;
	KLineEdit *propertyNameEdit;
	KLineEdit *propertyUnits;
	TQLabel *nameEditText;
	TQLabel *unitsText;

	//Internal variables
	UnitList *unitList;

	//Methods
	void loadUnits();
};

#endif
