/***************************************************************************
*   Copyright (C) 2005 by Jason Kivlighn                                  *
*   jkivlighn@gmail.com                                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef EDITRATINGDIALOG_H
#define EDITRATINGDIALOG_H

#include <kdialogbase.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQLabel;
class TQComboBox;
class KDoubleSpinBox;
class TQPushButton;
class TDEListView;
class TQListViewItem;
class TQTextEdit;
class TQLineEdit;
class RatingWidget;

class Rating;
class RatingCriteria;
class ElementList;
class RatingCriteriaListView;

class EditRatingDialog : public KDialogBase
{
Q_OBJECT
	
public:
	EditRatingDialog( const ElementList &criteriaList, const Rating &, TQWidget* parent = 0, const char* name = 0 );
	EditRatingDialog( const ElementList &criteriaList, TQWidget* parent = 0, const char* name = 0 );
	~EditRatingDialog();
	
	TQLabel* criteriaLabel;
	TQComboBox* criteriaComboBox;
	TQLabel* starsLabel;
	RatingWidget *starsWidget;
	TQPushButton* addButton;
	TQPushButton* removeButton;
	RatingCriteriaListView* criteriaListView;
	TQLabel* commentsLabel;
	TQTextEdit* commentsEdit;
	TQLabel* raterLabel;
	TQLineEdit* raterEdit;

	Rating rating() const;
	
protected:
	TQHBox* layout8;
	TQHBox* layout2;
	
protected slots:
	virtual void languageChange();
	void slotAddRatingCriteria();
	void slotRemoveRatingCriteria();
	void itemRenamed(TQListViewItem* it, const TQString &, int c);

private:
	void init(const ElementList &criteriaList);

	void loadRating( const Rating & );
	void addRatingCriteria( const RatingCriteria &rc );

	int ratingID;
};

#endif // EDITRATINGDIALOG_H
