/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   Copyright (C) 2006 Jason Kivlighn (jkivlighn@gmail.com)               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef INGREDIENTMATCHERDIALOG_H
#define INGREDIENTMATCHERDIALOG_H

#include "datablocks/element.h"
#include "datablocks/ingredientlist.h"
#include "datablocks/recipe.h"
#include "widgets/recipelistview.h"
#include "widgets/dblistviewbase.h"

#include <ntqfontmetrics.h>
#include <ntqlabel.h>
#include <ntqlistview.h>
#include <ntqpushbutton.h>
#include <ntqhbox.h>
#include <ntqvbox.h>

#include <kstringhandler.h>
#include <tdelocale.h>

class KreListView;
class KIntSpinBox;
class RecipeDB;
class MixedNumber;

/**
@author Unai Garro
*/

class CustomRecipeListItem : public RecipeListItem
{
public:
	CustomRecipeListItem( TQListView* qlv, const Recipe &r, const IngredientList &il ) : RecipeListItem( qlv, r )
	{
		ingredientListStored = new TQStringList();
		IngredientList::ConstIterator ili;
		for ( ili = il.begin();ili != il.end();++ili ) {
			if ( (*ili).substitutes.count() > 0 ) {
				TQStringList subs;
				subs << ( *ili ).name;
				for ( TQValueList<IngredientData>::const_iterator it = (*ili).substitutes.begin(); it != (*ili).substitutes.end(); ++it ) {
 					subs << (*it).name;
				}
				ingredientListStored->append( subs.join(TQString(" %1 ").arg(i18n("OR"))) );
			}
			else
				ingredientListStored->append( ( *ili ).name );
		}

		moveItem( qlv->lastItem() );
	}
	CustomRecipeListItem( TQListView* qlv, const Recipe &r ) : RecipeListItem( qlv, r )
	{
		ingredientListStored = 0;

		moveItem( qlv->lastItem() );
	}

	~CustomRecipeListItem( void )
	{
		delete ingredientListStored;
	}

private:
	TQStringList *ingredientListStored;

public:
	virtual TQString text( int column ) const
	{
		if ( column == 2 && ingredientListStored )
			return ingredientListStored->join ( "," );
		else
			return ( RecipeListItem::text( column ) );
	}
};

class SectionItem: public TQListViewItem
{
public:
	SectionItem( TQListView* qlv, TQString sectionText ) : TQListViewItem( qlv, qlv->lastItem() )
	{
		mText = sectionText;
	}

	~SectionItem( void )
	{}
	virtual void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );

private:
	TQString mText;

public:
	virtual TQString text( int column ) const
	{
		if ( column == 0 )
			return ( mText );
		else
			return ( TQString::null );
	}
};
class IngredientMatcherDialog: public TQWidget
{

	Q_OBJECT

public:

	IngredientMatcherDialog( TQWidget *parent, RecipeDB* db );
	~IngredientMatcherDialog();
	void reload( ReloadFlags flag = Load );

signals:
	void recipeSelected( int, int );

private:
	//Private variables
	RecipeDB *database;

	//Widgets

	KreListView *allIngListView;
	KreListView *ingListView;

	KreListView *recipeListView;
	TQHBox *missingBox;
	TQLabel *missingNumberLabel;
	KIntSpinBox *missingNumberSpinBox;

	TQPushButton *okButton;
	TQPushButton *clearButton;
	TQPushButton *addButton;
	TQPushButton *removeButton;

	IngredientList m_ingredientList;
	TQMap<TQListViewItem*, IngredientList::iterator> m_item_ing_map;

private slots:
	void findRecipes( void );
	void unselectIngredients();
	void addIngredient();
	void removeIngredient();
	void itemRenamed( TQListViewItem*, const TQPoint &, int col );
};

#endif
