/***************************************************************************
*   Copyright (C) 2003 by Jason Kivlighn                                  *
*   (jkivlighn@gmail.com)                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef SETUPDISPLAY_H
#define SETUPDISPLAY_H

#include <tdehtml_part.h>
#include <dom/html_element.h>
#include <dom/css_stylesheet.h>

#include <ntqdom.h>
#include <ntqwidget.h>
#include <ntqmap.h>

#include "datablocks/recipe.h"
#include "datablocks/kreborder.h"
#include "klomanager.h"

#include <math.h>

class TDEPopupMenu;

class TQAction;
class TQLabel;
class TQWidget;

class StyleSheet;

class KreDisplayItem
{
public:
	KreDisplayItem( const TQString &id, const TQString &name );

	void clear();

	TQString nodeId;
	TQString name;
	KreBorder border;
	int alignment;
	int columns;
	bool show;
	TQColor backgroundColor;
	TQColor textColor;
	TQFont font;
};

typedef TQMap< KreDisplayItem*, unsigned int > PropertiesMap;

/** @brief A TDEHTMLPart for editing specific CSS properties
  *
  * Set up the items of a recipe for display.
  *
  * @author Jason Kivlighn
  */
class SetupDisplay : public TDEHTMLPart, protected KLOManager
{
	Q_OBJECT

public:
	SetupDisplay( const Recipe &, TQWidget *parent );
	~SetupDisplay();

	enum Properties { None = 0, BackgroundColor = 1, TextColor = 2, Font = 4, Visibility = 8, Alignment = 32, Columns = 64, Border = 128 };

	void saveLayout( const TQString & );
	void loadLayout( const TQString & );
	void loadTemplate( const TQString &filename );

	bool hasChanges() const
	{
		return has_changes;
	}

	void setItemShown( KreDisplayItem *item, bool visible );

	const PropertiesMap properties() const
	{
		return * box_properties;
	}

	void reload();

signals:
	void itemVisibilityChanged( KreDisplayItem *, bool );

protected:
	virtual void begin (const KURL &url=KURL(), int xOffset=0, int yOffset=0);

	virtual void loadBackgroundColor( const TQString &obj, const TQColor& );
	virtual void loadFont( const TQString &obj, const TQFont& );
	virtual void loadTextColor( const TQString &obj, const TQColor& );
	virtual void loadVisibility( const TQString &obj, bool );
	virtual void loadAlignment( const TQString &obj, int );
	virtual void loadBorder( const TQString &obj, const KreBorder& );
	virtual void loadColumns( const TQString &obj, int );

	virtual void beginObject( const TQString &obj );
	virtual void endObject();

protected slots:
	void nodeClicked(const TQString &url,const TQPoint &point);
	void changeMade();

	//slots to set properties of item boxes
	void setBackgroundColor();
	void setBorder();
	void setColumns();
	void setTextColor();
	void setFont();
	void setShown( int id );
	void setAlignment( TQAction * );

private:
	PropertiesMap *box_properties;
	TQMap<TQString, KreDisplayItem*> *node_item_map;

	bool has_changes;

	// Methods
	void applyStylesheet();
	void loadPageLayout( const TQDomElement &tag );
	void loadHTMLView( const TQString &templateFile = TQString::null, const TQString &styleFile = TQString::null );

	void createItem( const TQString &id, const TQString &name, unsigned int properties );

	//the name of the element under the mouse on a right-click
	TQString m_currNodeId;

	//the item corresponding to the current point of processing the KLO
	KreDisplayItem *m_currentItem;

	TDEPopupMenu *popup;
	DOM::CSSStyleSheet m_styleSheet;
	Recipe m_sample;

	TQString m_activeTemplate;
	TQString m_activeStyle;
};

#endif //SETUPDISPLAY_H

