/***************************************************************************
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KREIMPORTER_H
#define KREIMPORTER_H

#include <tdelocale.h>
#include <kstandarddirs.h>
#include <kmdcodec.h>
#include <ktar.h>
#include <tdetempfile.h>

#include <ntqfile.h>
#include <ntqstringlist.h>
#include <ntqdom.h>

#include "baseimporter.h"

#include "datablocks/recipe.h"

class Recipe;
class CategoryTree;

/**
Import for Krecipes native file format (.kre, .kreml)
 
@author Cyril Bosselut, Jason Kivlighn
*/
class KreImporter: public BaseImporter
{
public:
	KreImporter();
	virtual ~KreImporter();

private:
	void parseFile( const TQString& filename );

private:
	void readCategoryStructure( const TQDomNodeList& l, CategoryTree *tree );
	void readDescription( const TQDomNodeList& l, Recipe* );
	void readIngredients( const TQDomNodeList& l, Recipe*, const TQString &header = TQString::null, Ingredient *ing = 0 );
	void readAmount( const TQDomElement& amount1, double &amount2, double &amount_offset );
	void readRatings( const TQDomNodeList&, Recipe * );
	void readCriterion( const TQDomNodeList&, RatingCriteriaList &r );
};

#endif
