/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef SETUPWIZARD_H
#define SETUPWIZARD_H

#include <ntqvbuttongroup.h>
#include <ntqcheckbox.h>
#include <ntqradiobutton.h>
#include <ntqlabel.h>
#include <kwizard.h>
#include <klineedit.h>
#include <ktextedit.h>


/**
@author Unai Garro
*/

class WelcomePage;
class DBTypeSetupPage;
class PermissionsSetupPage;
class PSqlPermissionsSetupPage;
class ServerSetupPage;
class DataInitializePage;
class SavePage;
class SQLiteSetupPage;

enum DBType {SQLite, MySQL, PostgreSQL};

class SetupWizard: public KWizard
{
	Q_OBJECT
public:

	SetupWizard( TQWidget *parent = 0, const char *name = 0, bool modal = true, WFlags f = 0 );
	~SetupWizard();
	void getOptions( bool &setupUser, bool &initializeData, bool &doUSDAImport );
	void getAdminInfo( bool &enabled, TQString &adminUser, TQString &adminPass, const TQString &dbType );
	void getServerInfo( bool &isRemote, TQString &host, TQString &client, TQString &dbName, TQString &user, TQString &pass, int &port );
private:
	// Widgets
	WelcomePage *welcomePage;
	DBTypeSetupPage *dbTypeSetupPage;
	PermissionsSetupPage *permissionsSetupPage;
	PSqlPermissionsSetupPage *pSqlPermissionsSetupPage;
	ServerSetupPage *serverSetupPage;
	DataInitializePage *dataInitializePage;
	SQLiteSetupPage *sqliteSetupPage;
	SavePage *savePage;

private slots:
	void save( void );
	void showPages( DBType );

};

class WelcomePage: public TQWidget
{
public:
	// Methods
	WelcomePage( TQWidget *parent );

private:
	// Widgets
	TQLabel *logo;
	TQLabel *welcomeText;

};


class PermissionsSetupPage: public TQWidget
{
	Q_OBJECT
public:
	// Methods
	PermissionsSetupPage( TQWidget *parent );
	bool doUserSetup( void );
	bool useAdmin( void );
	void getAdmin( TQString &adminName, TQString &adminPass );
private:
	// Widgets
	TQLabel *logo;
	TQLabel *permissionsText;
	TQCheckBox *noSetupCheckBox;
	TQCheckBox *rootCheckBox;
	TQLineEdit *userEdit;
	TQLineEdit *passEdit;

private slots:
	void rootCheckBoxChanged( bool on );
	void noSetupCheckBoxChanged( bool on );

};

class PSqlPermissionsSetupPage: public TQWidget
{
	Q_OBJECT
public:
	// Methods
	PSqlPermissionsSetupPage( TQWidget *parent );
	bool doUserSetup( void );
	bool useAdmin( void );
	void getAdmin( TQString &adminName, TQString &adminPass );
private:
	// Widgets
	TQLabel *logo;
	TQLabel *permissionsText;
	TQCheckBox *noSetupCheckBox;
	TQCheckBox *rootCheckBox;
	TQLineEdit *userEdit;
	TQLineEdit *passEdit;

private slots:
	void rootCheckBoxChanged( bool on );
	void noSetupCheckBoxChanged( bool on );

};

class ServerSetupPage: public TQWidget
{
public:
	// Methods
	ServerSetupPage( TQWidget *parent );
	TQString user( void );
	TQString password( void );
	TQString dbName( void );
	TQString server( void );
	TQString client( void );
	void getServerInfo( bool &isRemote, TQString &host, TQString &client, TQString &dbName, TQString &user, TQString &pass, int &port );
private:
	// Widgets
	TQLabel *logo;
	TQLabel *serverSetupText;
	KLineEdit *usernameEdit;
	KLineEdit *passwordEdit;
	KLineEdit *dbNameEdit;
	TQCheckBox *remoteServerCheckBox;
	KLineEdit *serverEdit;
	KLineEdit *clientEdit;
};


class SQLiteSetupPage: public TQWidget
{
	Q_OBJECT

public:
	// Methods
	SQLiteSetupPage( TQWidget *parent );
	TQString dbFile() const;

private slots:
	void selectFile();

private:
	// Widgets
	TQLabel *logo;
	TQLabel *serverSetupText;
	KLineEdit *fileEdit;
};


class DataInitializePage: public TQWidget
{
public:
	// Methods
	DataInitializePage( TQWidget *parent );
	bool doInitialization( void );
	bool doUSDAImport( void );

private:
	// Widgets
	TQLabel *logo;
	TQLabel *initializeText;
	TQLabel *USDAImportText;
	TQCheckBox *initializeCheckBox;
	TQCheckBox *USDAImportCheckBox;

};

class SavePage: public TQWidget
{
public:
	// Methods
	SavePage( TQWidget *parent );
private:
	// Widgets
	TQLabel *logo;
	TQLabel *saveText;

};

class DBTypeSetupPage: public TQWidget
{

	Q_OBJECT

public:
	// Methods
	DBTypeSetupPage( TQWidget *parent );
	int dbType( void );
private:
	// Widgets
	TQLabel *dbTypeSetupText;
	TQLabel *logo;
	TQVButtonGroup *bg;
	TQRadioButton *liteCheckBox;
	TQRadioButton *mysqlCheckBox;
	TQRadioButton *psqlCheckBox;
private slots:
	void setPages( int rb ); // hides/shows pages given the radio button state
signals:
	void showPages( DBType );
};

#endif
