/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KRETEXTEDIT_H
#define KRETEXTEDIT_H

#include <ktextedit.h>
#include <kcompletion.h>

#include "datablocks/elementlist.h"

/*  @author Jason Kivlighn
 *  @brief An extended KTextEdit that allows for text completion
 */
class KreTextEdit : public KTextEdit, TDECompletionBase
{
	Q_OBJECT

public:
	KreTextEdit( TQWidget *parent );

	virtual void setCompletedText( const TQString &text );
	virtual void setCompletedItems( const TQStringList &items );

public slots:
	void addCompletionItem( const TQString & );
	void removeCompletionItem( const TQString & );
	void clearCompletionItems();

protected:
	void keyPressEvent( TQKeyEvent * );

private slots:
	void haltCompletion();

private:
	void tryCompletion();
	void rotateText( TDECompletionBase::KeyBindingType type );

	bool completing;
	int completion_begin;

};

#endif //KRETEXTEDIT_H
