/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   Copyright (C) 2006 Jason Kivlighn (jkivlighn@gmail.com)               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPELISTVIEW_H
#define RECIPELISTVIEW_H

#include <ntqdragobject.h>

#include "categorylistview.h"
#include "datablocks/recipe.h"

class TQDragObject;
class TQDropEvent;

class KProgressDialog;

class RecipeDB;

#define RECIPELISTITEM_RTTI 1000

#define RECIPEITEMMIMETYPE "data/x-kde.recipe.item"

class RecipeListItem : public TQListViewItem
{
public:
	RecipeListItem( TQListView* qlv, const Recipe &r ) : TQListViewItem( qlv )
	{
		init( r );
	}

	RecipeListItem( TQListView* qlv, TQListViewItem *after, const Recipe &r ) : TQListViewItem( qlv, after )
	{
		init( r );
	}

	RecipeListItem( CategoryListItem* it, const Recipe &r ) : TQListViewItem( it )
	{
		init( r );
	}

	RecipeListItem( CategoryListItem* it, TQListViewItem *after, const Recipe &r ) : TQListViewItem( it, after )
	{
		init( r );
	}

	RecipeListItem( TQListViewItem* it, const Recipe &r ) : TQListViewItem( it )
	{
		init( r );
	}

	int rtti() const
	{
		return RECIPELISTITEM_RTTI;
	}

	~RecipeListItem( void )
	{
		delete recipeStored;
	}

	int recipeID() const
	{
		return recipeStored->recipeID;
	}
	TQString title() const
	{
		return recipeStored->title;
	}

	void setRecipeID( int id )
	{
		recipeStored->recipeID = id;
	}
	void setTitle( const TQString &title )
	{
		recipeStored->title = title;
	}

protected:
	Recipe *recipeStored;

public:
	virtual TQString text( int column ) const
	{
		switch ( column ) {
		case 0:
			return ( recipeStored->title );
			break;
		case 1:
			return ( TQString::number( recipeStored->recipeID ) );
			break;
		default:
			return ( TQString::null );
		}
	}

private:
	void init( const Recipe &r )
	{
		recipeStored = new Recipe();

		//note: we only store the title and id
		recipeStored->recipeID = r.recipeID;
		recipeStored->title = r.title;
	}
};

class RecipeItemDrag : public TQStoredDrag
{
public:
	RecipeItemDrag( RecipeListItem *recipeItem, TQWidget *dragSource = 0, const char *name = 0 );
	static bool canDecode( TQMimeSource* e );
	static bool decode( const TQMimeSource* e, RecipeListItem& item );
};

class RecipeListView : public StdCategoryListView
{
	Q_OBJECT

public:
	RecipeListView( TQWidget *parent, RecipeDB *db );

public slots:
	void populateAll( TQListViewItem *parent = 0 );

protected slots:
	virtual void createRecipe( const Recipe &, int parent_id );
	virtual void createRecipe( const Element &recipe, const ElementList &categories );
	virtual void modifyRecipe( const Element &recipe, const ElementList &categories );
	virtual void removeRecipe( int );
	virtual void removeRecipe( int, int );

protected:
	virtual void init();
	virtual void createElement( TQListViewItem * );
	virtual void removeCategory( int id );
	virtual TQDragObject *dragObject();
	virtual bool acceptDrag( TQDropEvent *event ) const;
	virtual void populate( TQListViewItem *item );
	virtual TQString tooltip(TQListViewItem *item, int column) const;

	friend class RecipeListToolTip;

	void load(int limit, int offset);

private:
	void moveChildrenToRoot( TQListViewItem * );

	bool flat_list;
	TQListViewItem *m_uncat_item;
	TQListViewItem *lastElementCurrLevel;

	KProgressDialog *m_progress_dlg;
};

#endif //RECIPELISTVIEW_H
