/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef ADVANCEDSEARCHDIALOG_H
#define ADVANCEDSEARCHDIALOG_H

#include <ntqwidget.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQScrollView;
class TQPushButton;
class TQFrame;
class TQLineEdit;
class TQLabel;
class TQCheckBox;
class TQComboBox;
class TQSpinBox;
class TQTimeEdit;
class KPushButton;
class TDEListView;
class TQListViewItem;
class TQRadioButton;
class TQButtonGroup;

class KDateEdit;
class RecipeDB;
class RecipeActionsHandler;
class FractionInput;
class CriteriaComboBox;


class AdvancedSearchDialog : public TQWidget
{
	TQ_OBJECT

public:
	AdvancedSearchDialog( TQWidget *parent, RecipeDB * );
	~AdvancedSearchDialog();

	virtual void languageChange();

	RecipeActionsHandler *actionHandler;

protected:
	TQLabel* textLabel1_4;
	TQScrollView* scrollView1;
	TQFrame* parametersFrame;
	TQLineEdit* titleEdit;
	TQPushButton* titleButton;
	TQFrame* titleFrame;
	TQPushButton* ingredientButton;
	TQFrame* ingredientFrame;
	TQLineEdit* ingredientsAllEdit;
	TQLineEdit* ingredientsAnyEdit;
	TQLabel* textLabel1_2;
	TQLabel* textLabel1;
	TQLineEdit* ingredientsWithoutEdit;
	TQLabel* textLabel1_3;
	TQPushButton* categoriesButton;
	TQFrame* categoryFrame;
	TQLineEdit* categoriesAllEdit;
	TQLabel* textLabel1_5;
	TQLabel* textLabel1_3_3;
	TQLineEdit* categoriesAnyEdit;
	TQLabel* textLabel1_2_3;
	TQLineEdit* categoriesNotEdit;
	TQPushButton* authorsButton;
	TQFrame* authorsFrame;
	TQLabel* textLabel1_2_4;
	TQLabel* textLabel1_6;
	TQLabel* textLabel1_3_4;
	TQLineEdit* authorsAnyEdit;
	TQLineEdit* authorsAllEdit;
	TQLineEdit* authorsWithoutEdit;
	TQPushButton* servingsButton;
	TQFrame* servingsFrame;
	TQCheckBox* enableServingsCheckBox;
	TQComboBox* servingsComboBox;
	TQSpinBox* servingsSpinBox;
	TQPushButton* prepTimeButton;
	TQFrame* prepTimeFrame;
	TQCheckBox* enablePrepTimeCheckBox;
	TQComboBox* prepTimeComboBox;
	TQTimeEdit* prepTimeEdit;
	TQLineEdit* instructionsEdit;
	TQPushButton* instructionsButton;
	TQFrame* instructionsFrame;
	KPushButton* clearButton;
	KPushButton* findButton;
	TDEListView* resultsListView;
	TQCheckBox *requireAllTitle;
	TQCheckBox *requireAllInstructions;
	KDateEdit *createdStartDateEdit;
	KDateEdit *createdEndDateEdit;
	KDateEdit *modifiedStartDateEdit;
	KDateEdit *modifiedEndDateEdit;
	KDateEdit *accessedStartDateEdit;
	KDateEdit *accessedEndDateEdit;
	TQPushButton* metaDataButton;
	TQFrame* metaDataFrame;
	TQRadioButton* ratingAvgRadioButton;
	FractionInput* avgStarsEdit;
	TQLabel* avgStarsLabel;
	TQRadioButton* criterionRadioButton;
	CriteriaComboBox* criteriaComboBox;
	FractionInput* starsWidget;
	TQPushButton* addCriteriaButton;
	TQPushButton* removeCriteriaButton;
	TDEListView* criteriaListView;
	TQPushButton* ratingsButton;
	TQButtonGroup *ratingButtonGroup;
	TQFrame *ratingAvgFrame;
	TQFrame *criterionFrame;
	TQVBoxLayout *criterionFrameLayout;
	TQHBoxLayout *ratingAvgFrameLayout;
	TQVBoxLayout *ratingButtonGroupLayout;

	TQHBoxLayout* AdvancedSearchDialogLayout;
	TQVBoxLayout* layout7;
	TQHBoxLayout* scrollView1Layout;
	TQVBoxLayout* parametersFrameLayout;
	TQSpacerItem* spacer3_2_3_2_2;
	TQSpacerItem* spacer3_2_3_2;
	TQSpacerItem* spacer3_2_3;
	TQSpacerItem* spacer3_2_2;
	TQSpacerItem* titleFrameSpacer;
	TQSpacerItem* instructionsFrameSpacer;
	TQSpacerItem* metaDataFrameSpacer;
	TQSpacerItem* spacer15;
	TQVBoxLayout* titleFrameLayout;
	TQGridLayout* ingredientFrameLayout;
	TQGridLayout* categoryFrameLayout;
	TQGridLayout* authorsFrameLayout;
	TQVBoxLayout* servingsFrameLayout;
	TQHBoxLayout* layout5;
	TQVBoxLayout* prepTimeFrameLayout;
	TQVBoxLayout* instructionsFrameLayout;
	TQVBoxLayout* metaDataFrameLayout;
	TQHBoxLayout* layout6;
	TQHBoxLayout* layout9;
	TQSpacerItem* spacer3;
	TQVBoxLayout* ratingsFrameLayout;
	TQHBoxLayout* layout11;
	TQHBoxLayout* layout12;
	TQSpacerItem* ratingsFrameSpacer;

	RecipeDB *database;

signals:
	void recipeSelected( int, int );
	void recipesSelected( const TQValueList<int> &, int );

private slots:
	void search();
	void clear();
	void buttonSwitched();
	void activateRatingOption( int button_id );
	void slotAddRatingCriteria();
	void slotRemoveRatingCriteria();

	//called by a signal from the database when a recipe is removed
	void removeRecipe( int id );

private:
	TQStringList split( const TQString &text, bool sql_wildcards = false ) const;
};

#endif //ADVANCEDSEARCHDIALOG_H

