/***************************************************************************
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RECIPEMLEXPORTER_H
#define RECIPEMLEXPORTER_H

#include "baseexporter.h"

#include <ntqdom.h>

class IngredientData;

/**
  * Export class for the RecipeML file format <http://www.formatdata.com/recipeml>
  * @author Jason Kivlighn
  *
  * Note: This format does not handle all the properties of recipes.
  *       Data lost in export to this format include:
  *           -Recipe photo
  */
class RecipeMLExporter : public BaseExporter
{
public:
	RecipeMLExporter( const TQString&, const TQString& );
	virtual ~RecipeMLExporter();

	virtual int supportedItems() const;

protected:
	virtual TQString createContent( const RecipeList& );
	virtual TQString createHeader( const RecipeList& );
	virtual TQString createFooter();

private:
	void createIngredient( TQDomElement &ing_tag, const IngredientData &, TQDomDocument &doc );
};

#endif //RECIPEMLEXPORTER_H
