/***************************************************************************
*   Copyright (C) 2004-2006 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef UNIT_H
#define UNIT_H

#include <ntqstring.h>
#include <ntqvaluelist.h>

class Unit
{
public:
	Unit();
	Unit( const TQString &name, const TQString &plural, int id = -1 );

	typedef enum { All = -1, Other = 0, Mass, Volume } Type;

	/** Use @param amount to determine whether to use @param name as the plural or singlular form */
	Unit( const TQString &name, double amount );

	bool operator==( const Unit &u ) const;
	bool operator<( const Unit &u ) const;

	TQString determineName( double amount, bool useAbbrev ) const;

	Type type;

	int id;
	TQString name;
	TQString plural;

	TQString name_abbrev;
	TQString plural_abbrev;
};

typedef TQValueList< Unit > UnitList;

#endif //UNIT_H
