/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "selectpropertydialog.h"

#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdelocale.h>

#include "datablocks/ingredientpropertylist.h"

SelectPropertyDialog::SelectPropertyDialog( TQWidget* parent, IngredientPropertyList *propertyList, UnitList *unitList, OptionFlag showEmpty )
		: KDialogBase( parent, "SelectPropertyDialog", true, i18n( "Choose Property" ),
		    KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok ), m_showEmpty(showEmpty)
{

	// Initialize internal variables
	unitListBack = new UnitList;

	// Initialize Widgets
	TQVBox *page = makeVBoxMainWidget();

	box = new TQGroupBox( page );
	box->setTitle( i18n( "Choose Property" ) );
	box->setColumnLayout( 0, TQt::Vertical );
	box->layout() ->setSpacing( 6 );
	box->layout() ->setMargin( 11 );
	TQVBoxLayout *boxLayout = new TQVBoxLayout( box->layout() );
	boxLayout->setAlignment( TQt::AlignTop );

	propertyChooseView = new TDEListView( box, "propertyChooseView" );

	TDEConfig *config = TDEGlobal::config();
	config->setGroup( "Advanced" );
	bool show_id = config->readBoolEntry( "ShowID", false );
	propertyChooseView->addColumn( i18n( "Id" ), show_id ? -1 : 0 );

	propertyChooseView->addColumn( i18n( "Property" ) );
	propertyChooseView->setAllColumnsShowFocus( true );
	boxLayout->addWidget( propertyChooseView );

	TQHBoxLayout *layout2 = new TQHBoxLayout;

	perUnitsLabel = new TQLabel( box );
	perUnitsLabel->setGeometry( TQRect( 5, 285, 100, 30 ) );
	perUnitsLabel->setText( i18n( "Per units:" ) );
	layout2->addWidget( perUnitsLabel );

	perUnitsBox = new KComboBox( FALSE, box );
	layout2->addWidget( perUnitsBox );
	boxLayout->addLayout( layout2 );

	resize( TQSize( 200, 380 ).expandedTo( minimumSizeHint() ) );
	clearWState( WState_Polished );

	// Load data
	loadProperties( propertyList );
	loadUnits( unitList );
}


SelectPropertyDialog::~SelectPropertyDialog()
{}


int SelectPropertyDialog::propertyID( void )
{

	TQListViewItem * it;
	if ( ( it = propertyChooseView->selectedItem() ) ) {
		return ( it->text( 0 ).toInt() );
	}
	else
		return ( -1 );
}

int SelectPropertyDialog::perUnitsID()
{

	int comboCount = perUnitsBox->count();
	if ( comboCount > 0 ) { // If not, the list may be empty (no list defined) and crashes while reading as seen before. So check just in case.
		int comboID = perUnitsBox->currentItem();
		return ( *unitListBack->at( comboID ) ).id;
	}
	else
		return ( -1 );
}

void SelectPropertyDialog::loadProperties( IngredientPropertyList *propertyList )
{
	for ( IngredientPropertyList::const_iterator prop_it = propertyList->begin(); prop_it != propertyList->end(); ++prop_it ) {
		( void ) new TQListViewItem( propertyChooseView, TQString::number( (*prop_it).id ), (*prop_it).name );
	}
}
void SelectPropertyDialog::loadUnits( UnitList *unitList )
{
	for ( UnitList::const_iterator unit_it = unitList->begin(); unit_it != unitList->end(); ++unit_it ) {
		TQString unitName = ( *unit_it ).name;
		if ( unitName.isEmpty() ) {
			if ( m_showEmpty == ShowEmptyUnit )
				unitName = " "+i18n("-No unit-");
			else
				continue;
		}

		// Insert in the combobox
		perUnitsBox->insertItem( unitName );

		// Store with index for using later
		Unit newUnit( *unit_it );
		newUnit.name = unitName;
		unitListBack->append( newUnit );
	}
}
