/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef CONVERSIONTABLE_H
#define CONVERSIONTABLE_H
#include <ntqstring.h>
#include <ntqtable.h>
#include <ntqobject.h>

#include "datablocks/unitratio.h"
#include "datablocks/elementlist.h"
#include "datablocks/unit.h"

/**
@author Unai Garro
*/


class ConversionTable: public TQTable
{
	TQ_OBJECT
public:

	ConversionTable( TQWidget* parent, int maxrows, int maxcols );
	~ConversionTable();
	void createNewItem( int r, int c, double amount );
	void setUnitIDs( const IDList &idList );
	void setRatio( int ingID1, int ingID2, double ratio );
	void setRatio( const UnitRatio &r )
	{
		setRatio( r.uID1, r.uID2, r.ratio );
	}
	int getUnitID( int rc );
	TQString text( int r, int c ) const; //Reimplement, otherwise it won't work this way
	void resize( int r, int c );
	void clear( void );
private:

	//Internal Variables
	double editBoxValue;
	TQIntDict<TQTableItem> items;
	TQIntDict<TQWidget> widgets;
	IDList unitIDs; // unit ID list to know the units by ID, not name
	//Internal Methods
	void resizeData( int )
	{}
	;
	TQTableItem *item( int r, int c ) const;
	void setItem( int r, int c, TQTableItem *i );
	void clearCell( int r, int c );
	void takeItem( TQTableItem *item );
	void insertWidget( int r, int c, TQWidget *w );
	TQWidget *cellWidget( int r, int c ) const;
	void clearCellWidget( int r, int c );
	void initTable();
	void swapRows( int, int, bool );
	void swapColumns( int, int, bool );
	void swapCells( int, int, int, int );
protected:
	TQWidget* beginEdit ( int row, int col, bool replace );

private slots:
	void repaintCell( int r, int c );

	void unitRemoved( int );
	void unitCreated( const Unit& );
signals:
	void ratioChanged( int row, int col, double value );
	void ratioRemoved( int row, int col );
};

class ConversionTableItem: public TQObject, public TQTableItem
{
	TQ_OBJECT
public:
	ConversionTableItem( TQTable *t, EditType et );
	TQWidget *createEditor() const;
	void setContentFromEditor( TQWidget *w );
	void setText( const TQString &s );
	void paint( TQPainter *p, const TQColorGroup &cg, const TQRect &cr, bool selected );
	void setTextAndSave( const TQString &s );
	int alignment() const
	{
		return TQt::AlignRight;
	}
signals:
	void ratioChanged( int row, int col, double value );
	void ratioRemoved( int row, int col );
	void signalRepaintCell( int r, int c );

};


#endif
