/*
  This file is part of libtdepim.

  Copyright (c) 2004 Bram Schoenmakers <bramschoenmakers@kde.nl>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor, 
  Boston, MA  02110-1301  USA
*/

#include <ntqdatetime.h>
#include <ntqpopupmenu.h>

#include <tdelocale.h>

#include "kdatepickerpopup.h"

KDatePickerPopup::KDatePickerPopup( int items, const TQDate &date, TQWidget *parent,
                                    const char *name )
  : TQPopupMenu( parent, name )
{
  mItems = items;

  mDatePicker = new KDatePicker( this );
  mDatePicker->setCloseButton( false );

  connect( mDatePicker, TQ_SIGNAL( dateEntered( TQDate ) ),
           TQ_SLOT( slotDateChanged( TQDate ) ) );
  connect( mDatePicker, TQ_SIGNAL( dateSelected( TQDate ) ),
           TQ_SLOT( slotDateChanged( TQDate ) ) );

  mDatePicker->setDate( date );

  buildMenu();
}

void KDatePickerPopup::buildMenu()
{
  if ( isVisible() ) return;
  clear();

  if ( mItems & DatePicker ) {
    insertItem( mDatePicker );

    if ( ( mItems & NoDate ) || ( mItems & Words ) )
      insertSeparator();
  }

  if ( mItems & Words ) {
    insertItem( i18n("&Today"), this, TQ_SLOT( slotToday() ) );
    insertItem( i18n("&Yesterday"), this, TQ_SLOT( slotYesterday() ) );
    insertItem( i18n("Last &Week"), this, TQ_SLOT( slotLastWeek() ) );
    insertItem( i18n("Last M&onth"), this, TQ_SLOT( slotLastMonth() ) );

    if ( mItems & NoDate )
      insertSeparator();
  }

  if ( mItems & NoDate )
    insertItem( i18n("No Date"), this, TQ_SLOT( slotNoDate() ) );
}

KDatePicker *KDatePickerPopup::datePicker() const
{
  return mDatePicker;
}

void KDatePickerPopup::setDate( const TQDate &date )
{
  mDatePicker->setDate( date );
}

#if 0
void KDatePickerPopup::setItems( int items )
{
  mItems = items;
  buildMenu();
}
#endif

void KDatePickerPopup::slotDateChanged( TQDate date )
{
  emit dateChanged( date );
  hide();
}

void KDatePickerPopup::slotToday()
{
  emit dateChanged( TQDate::currentDate() );
}

void KDatePickerPopup::slotYesterday()
{
  emit dateChanged( TQDate::currentDate().addDays( -1 ) );
}

void KDatePickerPopup::slotNoDate()
{
  emit dateChanged( TQDate() );
}

void KDatePickerPopup::slotLastWeek()
{
  emit dateChanged( TQDate::currentDate().addDays( -7 ) );
}

void KDatePickerPopup::slotLastMonth()
{
  emit dateChanged( TQDate::currentDate().addMonths( -1 ) );
}

#include "kdatepickerpopup.moc"
