/***************************************************************************
*   Copyright (C) 2006 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef CREATEINGREDIENTWEIGHTDIALOG_H
#define CREATEINGREDIENTWEIGHTDIALOG_H

#include <kdialogbase.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQGroupBox;
class KLineEdit;
class KComboBox;
class TQLabel;
class TQPushButton;

class FractionInput;
class UnitComboBox;
class PrepMethodComboBox;
class RecipeDB;
class Weight;

class CreateIngredientWeightDialog : public KDialogBase
{
TQ_OBJECT
	
public:
	CreateIngredientWeightDialog( TQWidget* parent, RecipeDB* );
	~CreateIngredientWeightDialog();

	Weight weight() const;

protected:
	TQGridLayout* groupBox1Layout;
	
protected slots:
	virtual void languageChange();
	void slotOk();

private:
	TQGroupBox* groupBox1;
	FractionInput* perAmountEdit;
	FractionInput* weightEdit;
	UnitComboBox* weightUnitBox;
	TQLabel* perAmountLabel;
	TQLabel* weightLabel;
	UnitComboBox* perAmountUnitBox;
	PrepMethodComboBox* prepMethodBox;
};

#endif // CREATEINGREDIENTWEIGHTDIALOG_H
