/***************************************************************************
                  dsdirselectdialog.cpp  -  description
                             -------------------
    begin                : Sat Jan 03 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dsdirselectdialog.h"

// TQt includes
#include <tqcheckbox.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqvbox.h>

// KDE includes
#include <tdediroperator.h> 
#include <tdelocale.h>
#include <kurlcombobox.h> 

DSDirSelectDialog::DSDirSelectDialog( TQWidget* parent )
        : KFileDialog( ":KRename", "*", parent, 0, false ) 
{
    setOperationMode( KFileDialog::Opening );
    setMode( KFile::Files | KFile::ExistingOnly );
    
    TQVBox* vbox = new TQVBox( this );

    if( layout() )
        layout()->add( vbox );
    else
        tqDebug("KFileDialog does not have a layout!!!");

    checkDir = new TQCheckBox( i18n("Add directory names &with filenames"), vbox );
    check = new TQCheckBox( i18n("Add subdirectories &recursively"), vbox );
    TQHBox* hbox = new TQHBox( vbox );
    TQWidget* spacer = new TQWidget( hbox );
    spacer->setMinimumWidth( 20 );
    checkHidden = new TQCheckBox( i18n("Add &hidden directories"), hbox );
    hbox->setStretchFactor( checkHidden, 4 );
    checkOnlyDir = new TQCheckBox( i18n("Add directory names only"), vbox );    
    connect( check, TQT_SIGNAL( clicked() ), this, TQT_SLOT( enableControls() ));

    TQToolTip::add( check, i18n("Walk recursively through the directory tree and add also the content of all subdirectories to the list of files to rename.") );
    TQToolTip::add( checkHidden, i18n("If not checked, KRename will ignore directories starting with a dot during recursive adding.") );
    TQToolTip::add( checkOnlyDir, i18n("Add only the directory names and not the names of the files in the directory to KRename.") );
    TQToolTip::add( checkDir, i18n("This option causes KRename to add also the name of the base directory of the selected files to its list.") );
    
    enableControls();
}

bool DSDirSelectDialog::recursively() const
{
    return check->isChecked();
}

bool DSDirSelectDialog::hidden() const
{
    return checkHidden->isChecked();
}

bool DSDirSelectDialog::dirs() const
{
    return checkDir->isChecked();
}

bool DSDirSelectDialog::onlyDirs() const
{
    return checkOnlyDir->isChecked();
}

void DSDirSelectDialog::setRecursively( bool b )
{
    check->setChecked( b );
}

void DSDirSelectDialog::enableControls()
{
    checkHidden->setEnabled( check->isChecked() );
}

void DSDirSelectDialog::slotOk()
{
    const KFileItemList *items = ops->selectedItems();
    if ( !items || items->isEmpty() )
    {
        KDialogBase::accept();
    } else  
        KFileDialog::slotOk();
}

KURL::List DSDirSelectDialog::selectedURLs()
{
    KURL::List list = KFileDialog::selectedURLs();
    if( list.isEmpty() )
        list.append( baseURL() ); 
        
    return list;
}
#include "dsdirselectdialog.moc"
