/***************************************************************************
                          helpdialog.h  -  description
                             -------------------
    begin                : Fr Nov 15 13:44:19 CEST 2001
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPDIALOG_H
#define HELPDIALOG_H

#include <tqdialog.h>
#include <tqstringlist.h>
#include <tqpixmap.h>
#include <tqmap.h>

class TQVBoxLayout; 
class TQHBoxLayout; 
class TQGridLayout; 
class TQComboBox;
class TQLineEdit;
class TQPixmap;
class TDEListView;
class KPushButton;

class HelpDialogData : public TQObject {
    TQ_OBJECT
  
    public:
        HelpDialogData() {}
        ~HelpDialogData() {}
        
        void add( const TQString & headline, TQStringList* commands, const TQPixmap & icon, bool first = false );
        void remove( const TQString & headline );
        
        /** returns all available and supported tokens 
          */
        TQStringList tokens() const;
    
        inline const TQMap<TQString,TQStringList> & map() const
        {
            return m_map;
        }
        
        inline const TQMap<TQString,TQPixmap> & icons() const
        {
            return m_icons;
        }
        
        inline const TQString & first() const 
        {
            return m_first;
        }
        
    signals:
        void updateHeadline();
        void updateItems();
        
    private:
        TQMap<TQString,TQStringList> m_map;
        TQMap<TQString,TQPixmap> m_icons;
    
        TQString m_first;
};

class HelpDialog : public TQDialog
{ 
    TQ_OBJECT
  
    public:
        HelpDialog( HelpDialogData* data, TQWidget* parent = 0,
            const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~HelpDialog();

        inline void setLineEdit( TQLineEdit* lineedit );

    public slots:
        void updateItems();
        void updateHeadline();
        
    private slots:
        void execute();

    private:        
        TQComboBox* comboHeadline;
        TDEListView* list;
        KPushButton* buttonAdd;
        KPushButton* buttonClose;

    protected:
        HelpDialogData* m_data;
        
        TQLineEdit* text;

        TQVBoxLayout* HelpDialogLayout;
        TQHBoxLayout* Layout1;
};

void HelpDialog::setLineEdit( TQLineEdit* lineedit )
{ 
     text = lineedit; 
}

#endif // HELPDIALOG_H
