/***************************************************************************
                          kmyhistorycombo.h  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYHISTORYCOMBO_H
#define KMYHISTORYCOMBO_H

// KDE includes
#include <kcombobox.h>
#include <kcompletion.h>

class TQPopupMenu;
class TQTimer;

class KMyHistoryCombo : public KHistoryCombo  {
    TQ_OBJECT
  
    public:
        /** Create a new KMyHistoryCombo which has automatic KRename default history
         *  handling and a custom popup menu to insert tokens if customPopup is true
         *
         *  \param customPopup insert custom menu items into context menu.
         */
        KMyHistoryCombo(bool customPopup, TQWidget* parent=0, const char* name=0);
        ~KMyHistoryCombo();

        /**
         * Saves the settings of the HistoryCombo in the applications
         * config file in a group named name()
         * Saved settings include:
         * - history items
         * - completion items
         * - completion mode
         */
        void saveSettings();
        
        inline TQString text() const;

        TQString text( int index ) const;

        void setText( const TQString & text );
        void add( const TQString & text );
        bool isEmpty() const;
        
    signals:
        void delayedTextChanged();
        
    private slots:
        void textChangedGovernor();
        void slotCustomContextMenu( TQPopupMenu* p );
        void slotInsertKRenameCommand( int id );

    private:
        TQTimer* m_timer;
};

inline TQString KMyHistoryCombo::text() const
{ 
    return currentText(); 
}

#endif
