/***************************************************************************
                          lmsensorpanel.h  -  description
                             -------------------
    begin                : Sat Aug 11 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LMSENSORPANEL_H
#define LMSENSORPANEL_H

#include <ntqstring.h>

#include "panel.h"
#include "sensor.h"
#include "qdialarc.h"
#include "qlcdstring.h"


/**
  *@author 
  */

class LMSensorPanel : public Panel  {
   TQ_OBJECT
public: 

	LMSensorPanel(Sensor *newSensor, TQWidget *parent=0, const char *name=0);
	~LMSensorPanel();

public slots:

  void setValue(double value);
  void updateConfig();

protected:

  void resizeEvent ( TQResizeEvent * );

  void createTitleWidget();
  void createGraphicWidget();
  void createValueWidget();

  void timerEvent( TQTimerEvent * );
  void paletteChange(const TQPalette &oldPalette);

private:

  Sensor     *sensor;
  TQDialArc   *arc;
  TQLCDString *lcdDes;
  TQLCDString *lcdVal;
  TQString    valMask;
  bool       alarm;
};

#endif
