//
// C++ Interface: configgeneral
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CONFIGGENERAL_H
#define CONFIGGENERAL_H

//TQt headers
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqtooltip.h>
#include <tqlabel.h>

//KDE headers
#include <tdecmodule.h>
#include <tdeconfig.h>
#include <kgenericfactory.h>
#include <tdeapplication.h>

//KShowmail headers
#include <../constants.h>

/**
 * @brief Part of the setup dialog (KShowMailApp::SetupDialog) to configure general things.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class ConfigGeneral : public TDECModule
{
Q_OBJECT

  public:

    /**
     * Generic Constructor
     */
    ConfigGeneral( TQWidget *parent = 0, const char *name = 0, const TQStringList &args = TQStringList() );

    /**
     * Destructor
     */
    ~ConfigGeneral();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to reflect the current settings stored in the
     * config file.
     */
    virtual void load();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to default values.
     * This method is called when the user clicks the "Default" button.
     */
    virtual void defaults();

    /**
     * Overloaded method of TDECModule.
     * Stores the config information as shown in the user interface in the
     * config file.
     * Is called when the user clicks "Apply" or "Ok".
     */
    virtual void save();

  private:

    /**
     * Connector to the configuration file
     */
    TDEConfig* config;

    /**
     * Check box to select whether window closing must be confirmed.
     */
    TQCheckBox* chkConfirmClose;

    /**
     * Check box to select whether deleting must be confirmed.
     */
    TQCheckBox* chkConfirmDelete;

    /**
     * Check box to select whether the main window will be minimized at start.
     */
    TQCheckBox* chkStartMinimized;

    /**
     * Check box to select whether the close button leave the application running in tray.
     */
    TQCheckBox* chkCloseToTray;

    /**
     * Check box to select whether minimizes to the tray rather than to the taskbar.
     */
    TQCheckBox* chkMinimizeToTray;

    /**
     * Check box to select whether connection errors will be shown.
     */
    TQCheckBox* chkShowConnectionErrors;

    /**
     * Check box to select whether mails will be kept as new until termination.
     */
    TQCheckBox* chkKeepNew;

    /**
     * Spin box to set the initial timer.
     */
    TQSpinBox* spbInitial;

    /**
     * Spin box to set the interval timer.
     */
    TQSpinBox* spbInterval;

    /**
     * Spin box to set the time out timer.
     */
    TQSpinBox* spbTimeout;

  public slots:

    /**
     * Connected with the configuration items.
     * Calls the slot changed() of TDECModule to notify the dialog about the change.
     */
    void slotChanged();

};

#endif
