//
// C++ Interface: configlog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CONFIGLOG_H
#define CONFIGLOG_H

//button IDs
#define ID_BUTTON_REMOVE_AT_EXIT    1
#define ID_BUTTON_REMOVE_AFTER_DAYS 2

//qt headers
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqtooltip.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqspinbox.h>

//KDE headers
#include <tdecmodule.h>
#include <tdeconfig.h>
#include <kgenericfactory.h>
#include <tdeapplication.h>

//Kshowmail headers
#include "../constants.h"


/**
 * @brief Part of the setup dialog (KShowMailApp::SetupDialog) to configure the log.
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */
class ConfigLog : public TDECModule
{
Q_OBJECT

  public:

    /**
     * Generic constructor
     */
    ConfigLog( TQWidget* parent = 0, const char* name = 0, const TQStringList &args = TQStringList() );

    /**
     * Destructor
     */
    ~ConfigLog();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to reflect the current settings stored in the
     * config file.
     */
    virtual void load();

    /**
     * Overloaded method of TDECModule.
     * Sets the user interface elements to default values.
     * This method is called when the user clicks the "Default" button.
     */
    virtual void defaults();

    /**
     * Overloaded method of TDECModule.
     * Stores the config information as shown in the user interface in the
     * config file.
     * Is called when the user clicks "Apply" or "Ok".
     */
    virtual void save();

  private:

  /**
   * Connector to the configuration file
   */
    TDEConfig* config;

  /**
   * Checkbox to activate log of deleted mails
   */
  TQCheckBox* chkLogDeletedMails;

  /**
   * Checkbox to activate log of moved mails
   */
  TQCheckBox* chkLogMovedMails;

  /**
   * Combines the radio buttons to select the kind of removing log entries of deleted mails
   */
  TQButtonGroup* grpDelMailsRemove;

  /**
   * Combines the radio buttons to select the kind of removing log entries of moved mails
   */
  TQButtonGroup* grpMovMailsRemove;

  /**
   * Spinbox to select the number of days to remove.
   */
  TQSpinBox* spbDelDays;

  /**
   * Spinbox to select the number of days to remove.
   */
  TQSpinBox* spbMovDays;

  /**
   * Radio button to select the removing of entries about deleted mails at application exit.
   */
  TQRadioButton* btnDelMailsRemoveExit;

  /**
   * Radio button to select the removing of entries about deleted mails after some days.
   */
  TQRadioButton* btnDelMailsRemoveDays;

  /**
   * Radio button to select the removing of entries about moved mails at application exit.
   */
  TQRadioButton* btnMovMailsRemoveExit;

  /**
   * Radio button to select the removing of entries about moved mails after some days.
   */
  TQRadioButton* btnMovMailsRemoveDays;

  private slots:

  /**
   * Connected with the configuration items.
   * Calls the slot changed() of TDECModule to notify the dialog about the change.
   */
    void slotChanged();

  /**
   * Connected with the checkboxes and radiobuttons.
   * Enables or disables the dialog items.
   */
  void slotChangeItems();
};

#endif
