#ifndef __LOCKOUT_H__
#define __LOCKOUT_H__

#include <kpanelapplet.h>

class TDEAction;

/**
 * @short A KShutDown panel applet.
 * Based on the Lockout applet.
 */
class Lockout: public KPanelApplet
{
	Q_OBJECT
public:
	/**
	 * Constructs a new applet.
	 * @param configFile A configuration file (provided by the Kicker)
	 * @param parent A parent widget
	 */
	Lockout(const TQString& configFile, TQWidget *parent = 0);

	/**
	 * Destructor.
	 */
	~Lockout();

	/**
	 * Returns a suggested height for a given @p width.
	 */
	int heightForWidth(int width) const;

	/**
	 * Returns a suggested width for a given @p height.
	 */
	int widthForHeight(int height) const;
private:
	bool _transparent;
	TDEAction
		*_configureKShutDownAction,
		*_lockScreenAction,
		*_logoutAction,
		*_rebootAction,
		*_shutDownAction;
	void callKShutDown(const TQCString &function);
	void initActions();
	void runCommand(const TQString &command);
private slots:
	void slotCancel();
	void slotConfigureKShutDown();
	void slotIconChanged();
	void slotLockScreen();
	void slotLogout();
	void slotReboot();
	void slotShowKShutDown();
	void slotShutDown();
};

#endif // __LOCKOUT_H__
