/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THEMEMOODIN_H
#define THEMEMOODIN_H

#include <tqptrlist.h>

#include <kdebug.h>
#include <kpixmap.h>

#include <themeengine.h>
#include <objkstheme.h>

#include "scaler.h"
#include "cache.h"
#include "effectwidget.h"

typedef TQPtrList<EffectWidget> EffectWidgetList;
typedef TQValueList<TQPoint> CoordsList;
typedef TQValueList<TQColor> ColorList;
typedef TQValueList<TQFont> FontList;
typedef TQPtrList<TQImage> ImageList;

class ThemeMoodin: public ThemeEngine
{
  Q_OBJECT
  

public:
  ThemeMoodin(TQWidget *parent, const char *name, const TQStringList& flags);

  inline const TQString name() { return TQString("Moodin"); }
  inline const int version() { return 0x042; }

  static TQStringList names()
  {
    TQStringList l;

    l << "Moodin";

    return l;
  };

  static TQStringList statusPixmaps()
  {
    TQStringList l;

    l << "filetypes"; // 1 filetypes
    l << "application-x-executable"; // 2 application-x-executable
    l << "key_bindings"; // 3 key_bindings
    l << "window_duplicate"; // 4 window_duplicate
    l << "desktop"; // 5 desktop
    l << "style"; // 6 style
    l << "preferences-system"; // 7 preferences-system
    l << "go"; // 8 go

    return l;
  };

public slots:
  void slotSetText(const TQString& s);
  void slotSetPixmap(const TQString&);

private:
  bool mUseIconSet;
  bool mLabelShadow;
  bool mShowStatusText;
  bool mAppendX;
  bool mUsersBackground;
  bool mTranslate;
  bool mLineUpImages;
  bool mScaleIcons;
  bool mKubuntuStyle;
  int mAnimationLength;
  int mAnimationDelay;
  int mIconSetSize;
  int mCurrentStatusIndex;
  int mImageSpacer;
  int mLabelCount;
  float mBeginOpacity;

  TQString mCurrentAction;
  TQString mBackgroundImage;
  TQStringList mStatusIcons;
  TQStringList mStatusMessages;
  TQStringList mLabels;
  TQColor mStatusColor;
  TQColor mLabelShadowColor;
  TQFont mStatusFont;
  TQPoint mStatusCoords;
  TQPoint mLabelShadowOffset;
  TQWidget* mContainer;
  TQSize mBaseResolution;
  TQRect mSplashRect;

  KPixmap* mBG;

  Scaler* mScaler;
  Cache* mCache;

  EffectWidgetList mEffectWidgets;
  CoordsList mStatusIconCoords;
  CoordsList mStatusImageOffsets;
  CoordsList mLabelCoords;
  ColorList mLabelColors;
  FontList mLabelFonts;
  ImageList mImages;

  void init();
  void initBackground(TQPainter* p);
  void initEffectWidgets();
  void initLabels(TQPainter* p);

  void paintEvent(TQPaintEvent* pe);
  void readSettings();
  void arrangeWidget(TQWidget* me, const int index);
  void updateStatus();

  EffectWidget* createEffectWidget(TQWidget *parent, TQImage *image);
};

#endif
