/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void SQ_CodecSettingsSkeleton::init()
{
	w = 0;
	sett = 0;
}

void SQ_CodecSettingsSkeleton::addSettingsWidget(const TQString &path)
{
    w = TQWidgetFactory::create(path, 0, this, "skeleton_settings");
    TQWidget *fake;

    if(w)
        fake = TQT_TQWIDGET(w);
    else
	{
		pushApply->setEnabled(false);
		pushOK->setEnabled(false);

		TQTextEdit *t = new TQTextEdit(i18n("Error loading widget from <b>%1</b>. Please check your installation or contact <a href=\"mailto:ksquirrel.iv@gmail.com\">ksquirrel.iv@gmail.com</a>").arg(path), TQString(), groupBox);		
		t->setReadOnly(true);
		fake = t;
	}

    fake->reparent(groupBox, TQPoint(0,0), true);

    TQGridLayout *grid = new TQGridLayout(groupBox, 1, 1, 11, 6);
    grid->addMultiCellWidget(fake, 1, 1, 0, 3);

    TQSpacerItem *spacer = new TQSpacerItem(15, 1, TQSizePolicy::Minimum, TQSizePolicy::Expanding);
    grid->addItem(spacer, 2, 1);
}

void SQ_CodecSettingsSkeleton::recursivelyReadWrite(fmt_settings &settings, bool r)
{
    if(!w)
	return;

    TQObjectList ch = w->childrenListObject();
    fmt_settings::iterator t;

    for(TQObjectList::iterator it = ch.begin();it != ch.end();++it)
    {
	t = settings.find((*it)->name());

	if((*it)->inherits("TQCheckBox"))
	{
	    TQCheckBox *c = dynamic_cast<TQCheckBox *>(*it);

	    if(c && t != settings.end())
	    {
		if(r)
		    c->setChecked((*t).second.bVal);
		else
		    (*t).second.bVal = c->isChecked();
	    }
	}
	else if((*it)->inherits("TQButtonGroup"))
	{
	    TQButtonGroup *c = dynamic_cast<TQButtonGroup *>(*it);

	    if(c && t != settings.end())
	    {
		if(r)
		    c->setButton((*t).second.iVal);
		else
		    (*t).second.iVal = c->selectedId();
	    }
	}
	else if((*it)->inherits("TQSlider"))
	{
	    TQSlider *c = dynamic_cast<TQSlider *>(*it);

	    if(c && t != settings.end())
	    {
		if(r)
		    c->setValue((*t).second.iVal);
		else
		    (*t).second.iVal = c->value();
	    }
	}
	else if((*it)->inherits("KURLRequester"))
	{
	    KURLRequester *u = dynamic_cast<KURLRequester *>(*it);

	    if(u && t != settings.end())
	    {
		if(r)
		    u->setURL((*t).second.sVal);
		else
		{
                    KURL url = u->url(); // get rid of "file://" if present
		    (*t).second.sVal = url.isEmpty() ? "" : url.path().ascii();
		}
	    }
	}
	else if((*it)->inherits("KDoubleSpinBox"))
	{
	    KDoubleSpinBox *d = dynamic_cast<KDoubleSpinBox *>(*it);

	    if(d && t != settings.end())
	    {
		if(r)
		    d->setValue((*t).second.dVal);
		else
		    (*t).second.dVal = d->value();
	    }
	}
	// TQSpinBox should be checked after KDoubleSpinBox !
	else if((*it)->inherits("TQSpinBox"))
	{
	    TQSpinBox *c = dynamic_cast<TQSpinBox *>(*it);

	    if(c && t != settings.end())
	    {
		if(r)
		    c->setValue((*t).second.iVal);
		else
		    (*t).second.iVal = c->value();
	    }
        }
	else if((*it)->inherits("KColorButton"))
	{
	    KColorButton *c = dynamic_cast<KColorButton *>(*it);

	    if(c && t != settings.end())
	    {
		if(r)
		    c->setColor(TQColor(TQString((*t).second.sVal)));
		else
		    (*t).second.sVal = TQString(c->color().name()).ascii();
	    }
	}
    }
}

int SQ_CodecSettingsSkeleton::exec(fmt_settings &settings)
{
    // read settings
    recursivelyReadWrite(settings, true);

    sett = &settings;

    int result = TQDialog::exec();

    // save settings
    if(result == TQDialog::Accepted)
	recursivelyReadWrite(settings, false);

    return result;
}

void SQ_CodecSettingsSkeleton::setCodecInfo( const TQPixmap &pixmap, const TQString &text )
{
	codecIcon->setPixmap(pixmap);
	codecName->setText(text);
}

void SQ_CodecSettingsSkeleton::slotApply()
{
	recursivelyReadWrite(*sett, false);
	emit apply();
}
