//=================================================================================================
//
//   File : kvi_mdicaption.cpp
//   Creation date : Tue Sep 2 2003 02:35:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=================================================================================================

#define __KVIRC__

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_mdichild.h"
#include "kvi_mdimanager.h"
#include "kvi_string.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_settings.h"
#include "kvi_iconmanager.h"
#include "kvi_window.h"
#include "kvi_mdicaption.h"

#include <tqcursor.h>
#include <tqnamespace.h>
#include <tqapplication.h>
#include <tqfontmetrics.h>
#include "kvi_pointerlist.h"
#include <tqpixmap.h>
#include <tqstyle.h>
#include <tqpainter.h>
#include "kvi_tal_popupmenu.h"
	#include <tqsimplerichtext.h>
#include <tqdrawutil.h>
#include <tqevent.h>

KviMdiCaptionButton::KviMdiCaptionButton(const TQPixmap &pix,TQWidget * parent,const char * name)
: TQToolButton(parent,name)
{
	setPixmap(pix);
	//setAutoRaise(true);
	setMinimumSize(18,18);
}

KviMdiCaptionButton::~KviMdiCaptionButton()
{
}



void KviMdiCaptionButton::drawButton(TQPainter *p)
{
	TQBrush b(parentWidget()->colorGroup().background());
	
	if(isDown())
		qDrawShadePanel(p,0,0,width(),height(),colorGroup(),true,1,&b);
	else
		p->fillRect(0,0,width(),height(),b);

	drawButtonLabel(p);
}







KviMdiCaption::KviMdiCaption(KviMdiChild * parent,const char * name)
: TQWidget(parent,name)
{
	m_pMaximizeButton    = new KviMdiCaptionButton(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MAXIMIZE)),this,"maximize_button");
	connect(m_pMaximizeButton,TQT_SIGNAL(clicked()),parent,TQT_SLOT(maximize()));
	m_pMinimizeButton    = new KviMdiCaptionButton(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MINIMIZE)),this,"minimize_button");
	connect(m_pMinimizeButton,TQT_SIGNAL(clicked()),parent,TQT_SLOT(minimize()));
	m_pCloseButton       = new KviMdiCaptionButton(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CLOSE)),this,"close_button");
	connect(m_pCloseButton,TQT_SIGNAL(clicked()),parent,TQT_SLOT(closeRequest()));
	m_pSystemButton        = new KviMdiCaptionButton(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DEFAULTICON)),this,"icon_button");
	connect(m_pSystemButton,TQT_SIGNAL(clicked()),parent,TQT_SLOT(systemPopupSlot()));

	m_lastMousePos = TQPoint(-1,-1);
	m_bMouseGrabbed = true;
	m_bActive = false;
	calcLineSpacing();
}

KviMdiCaption::~KviMdiCaption()
{
}

void KviMdiCaption::reloadImages()
{
	m_pMaximizeButton->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MAXIMIZE)));
	m_pMinimizeButton->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MINIMIZE)));
	m_pCloseButton->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CLOSE)));
}

void KviMdiCaption::calcLineSpacing()
{
	TQFontMetrics fm(font());
	m_iLineSpacing = fm.lineSpacing() + 3;
	if(m_iLineSpacing < 20)m_iLineSpacing = 20;
}

int KviMdiCaption::heightHint()
{
	return m_iLineSpacing;
}

void KviMdiCaption::setActive(bool bActive)
{
	m_bActive = bActive;

	TQPalette pal(TQt::white,m_bActive ? KVI_OPTION_COLOR(KviOption_colorMdiCaptionActive) : KVI_OPTION_COLOR(KviOption_colorMdiCaptionInactive));
	setPalette(pal);
	//update();
	m_pSystemButton->update();
	m_pCloseButton->update();
	m_pMinimizeButton->update();
	m_pMaximizeButton->update();
}

void KviMdiCaption::fontChange(const TQFont &old)
{
	calcLineSpacing();
	TQWidget::fontChange(old);
	((KviMdiChild *)parent())->resizeEvent(0);
}

void KviMdiCaption::mousePressEvent(TQMouseEvent *e)
{
	m_bMouseGrabbed = true;
	m_lastMousePos = TQCursor::pos();
	setCursor(TQCursor::sizeAllCursor);
	((KviMdiChild *)parent())->activate(true);
}

void KviMdiCaption::mouseMoveEvent(TQMouseEvent *)
{
	if(m_bMouseGrabbed)
	{
		TQPoint p = TQCursor::pos();
		int dx = m_lastMousePos.x() - p.x();
		int dy = m_lastMousePos.y() - p.y();
		KviMdiChild * c = (KviMdiChild *)parent();

		int nx = c->manager()->childX(c) - dx;
		int ny = c->manager()->childY(c) - dy;

		if((nx < 0) || (ny < 0))
		{
			int cx = p.x();
			int cy = p.y();
			if(nx < 0)
			{
				cx -= nx;
				nx = 0;
			}
			if(ny < 0)
			{
				cy -= ny;
				ny = 0;
			}

			TQCursor::setPos(cx,cy);
			m_lastMousePos = TQPoint(cx,cy);
		} else {
			m_lastMousePos = p;
		}

		c->manager()->moveChild(c,nx,ny);
		c->manager()->childMoved(c);
	}
}

void KviMdiCaption::mouseDoubleClickEvent(TQMouseEvent *e)
{
	((KviMdiChild *)parent())->maximize();
}

void KviMdiCaption::paintEvent(TQPaintEvent * e)
{
	TQRect r = e->rect();
	TQPainter p(this);
	p.fillRect(r,m_bActive ? KVI_OPTION_COLOR(KviOption_colorMdiCaptionActive) : KVI_OPTION_COLOR(KviOption_colorMdiCaptionInactive));
	TQSimpleRichText rt(m_bActive ? ((KviMdiChild *)parent())->xmlActiveCaption() : ((KviMdiChild *)parent())->xmlInactiveCaption(),font());
	rt.draw(&p,height() + 2,-1,rect(),colorGroup());
}

void KviMdiCaption::mouseReleaseEvent(TQMouseEvent *)
{
	m_bMouseGrabbed = false;
	setCursor(TQCursor::arrowCursor);
//	releaseMouse();
}

void KviMdiCaption::setFocusProxy(TQWidget * w)
{
	TQWidget::setFocusProxy(w);
	m_pSystemButton->setFocusProxy(w);
	m_pMinimizeButton->setFocusProxy(w);
	m_pMaximizeButton->setFocusProxy(w);
	m_pCloseButton->setFocusProxy(w);
}

void KviMdiCaption::resizeEvent(TQResizeEvent * e)
{
	int s = height() - 2;
	m_pSystemButton->setGeometry(1,1,s,s);
	m_pCloseButton->setGeometry(width() - (s + 1),
		1,s,s);
	m_pMaximizeButton->setGeometry(width() - ((s << 1) + 2),
		1,s,s);
	m_pMinimizeButton->setGeometry(width() - ((s * 3) + 3),
		1,s,s);
}



KviMenuBarToolButton::KviMenuBarToolButton(TQWidget * par,const TQPixmap &img, const char * name)
: KviStyledToolButton(par)
{
	setProperty("name","name");
	setIconSet(img);
	setAutoRaise(true);
}

KviMenuBarToolButton::~KviMenuBarToolButton()
{
}

TQSize KviMenuBarToolButton::sizeHint() const
{
	return TQSize(20,20);
}

