#ifndef _KVI_TAL_LISTVIEW_QT3_H_
#define _KVI_TAL_LISTVIEW_QT3_H_

//=============================================================================
//
//   File : kvi_tal_listview_qt3.h
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include "kvi_qstring.h"

#include <tqlistview.h>

class KviTalListViewItem;

class KVILIB_API KviTalListView : public TQListView
{
	friend class KviTalCheckListItem;
	TQ_OBJECT
  
public:
	KviTalListView(TQWidget * pParent);
	virtual ~KviTalListView() {};
public:
	// Shadow the internal TQt methods
	KviTalListViewItem * firstChild() const { return (KviTalListViewItem *)TQListView::firstChild(); };
	KviTalListViewItem * lastItem() const { return (KviTalListViewItem *)TQListView::lastItem(); };
	KviTalListViewItem * selectedItem() const { return (KviTalListViewItem *)TQListView::selectedItem(); };
	KviTalListViewItem * currentItem() const { return (KviTalListViewItem *)TQListView::currentItem(); };
	KviTalListViewItem * itemAt(const TQPoint &pnt) const { return (KviTalListViewItem *)TQListView::itemAt(pnt); };
signals:
	void selectionChanged(KviTalListViewItem * pItem);
	void currentChanged(KviTalListViewItem * pItem);
	void clicked(KviTalListViewItem * pItem);
	void clicked(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void pressed(KviTalListViewItem * pItem);
	void pressed(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void doubleClicked(KviTalListViewItem * pItem);
	void doubleClicked(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void returnPressed(KviTalListViewItem * pItem);
	void spacePressed(KviTalListViewItem * pItem);
	void rightButtonClicked(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void rightButtonPressed(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void mouseButtonClicked(int iButton,KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void mouseButtonPressed(int iButton,KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void contextMenuRequested(KviTalListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void onItem(KviTalListViewItem * pItem);
	void expanded(KviTalListViewItem * pItem);
	void collapsed(KviTalListViewItem * pItem);
protected slots:
	void redirect_selectionChanged(TQListViewItem * pItem);
	void redirect_currentChanged(TQListViewItem * pItem);
	void redirect_clicked(TQListViewItem * pItem);
	void redirect_clicked(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_pressed(TQListViewItem * pItem);
	void redirect_pressed(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_doubleClicked(TQListViewItem * pItem);
	void redirect_doubleClicked(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_returnPressed(TQListViewItem * pItem);
	void redirect_spacePressed(TQListViewItem * pItem);
	void redirect_rightButtonClicked(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_rightButtonPressed(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_mouseButtonClicked(int iButton,TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_mouseButtonPressed(int iButton,TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_contextMenuRequested(TQListViewItem * pItem,const TQPoint &pnt,int uColumn);
	void redirect_onItem(TQListViewItem * pItem);
	void redirect_expanded(TQListViewItem * pItem);
	void redirect_collapsed(TQListViewItem * pItem);
};


class KVILIB_API KviTalListViewItem : public TQListViewItem
{
public:
	KviTalListViewItem(KviTalListView * pParent)
	: TQListViewItem(pParent) {};
	KviTalListViewItem(KviTalListViewItem * pParent)
	: TQListViewItem(pParent) {};
	KviTalListViewItem(KviTalListView * pParent,KviTalListViewItem * pAfter)
	: TQListViewItem(pParent,pAfter) {};
	KviTalListViewItem(KviTalListViewItem * pParent,KviTalListViewItem * pAfter)
	: TQListViewItem(pParent,pAfter) {};
	KviTalListViewItem(KviTalListView * pParent,const TQString &szLabel1,const TQString &szLabel2 = KviTQString::empty,const TQString &szLabel3 = KviTQString::empty,const TQString &szLabel4 = KviTQString::empty,const TQString &szLabel5 = KviTQString::empty)
	: TQListViewItem(pParent,szLabel1,szLabel2,szLabel3,szLabel4,szLabel5) {};
	KviTalListViewItem(KviTalListView * pParent,KviTalListViewItem * pAfter,const TQString &szLabel1,const TQString &szLabel2 = KviTQString::empty,const TQString &szLabel3 = KviTQString::empty,const TQString &szLabel4 = KviTQString::empty,const TQString &szLabel5 = KviTQString::empty)
	: TQListViewItem(pParent,pAfter,szLabel1,szLabel2,szLabel3,szLabel4,szLabel5) {};
	KviTalListViewItem(KviTalListViewItem * pParent,const TQString &szLabel1,const TQString &szLabel2 = KviTQString::empty,const TQString &szLabel3 = KviTQString::empty,const TQString &szLabel4 = KviTQString::empty)
	: TQListViewItem(pParent,szLabel1,szLabel2,szLabel3,szLabel4) {};
	KviTalListViewItem(KviTalListViewItem * pParent,KviTalListViewItem * pAfter,const TQString &szLabel1,const TQString &szLabel2 = KviTQString::empty,const TQString &szLabel3 = KviTQString::empty,const TQString &szLabel4 = KviTQString::empty)
	: TQListViewItem(pParent,pAfter,szLabel1,szLabel2,szLabel3,szLabel4) {};
	virtual ~KviTalListViewItem() {};
public:
	// Shadow the internal TQt methods
	KviTalListViewItem * firstChild() const { return (KviTalListViewItem *)TQListViewItem::firstChild(); };
	KviTalListViewItem * nextSibling() const { return (KviTalListViewItem *)TQListViewItem::nextSibling(); };
	KviTalListViewItem * parent() const { return (KviTalListViewItem *)TQListViewItem::parent(); };
	KviTalListView * listView() const { return (KviTalListView *)TQListViewItem::listView(); };
	KviTalListViewItem * itemAbove() { return (KviTalListViewItem *)TQListViewItem::itemAbove(); };
	KviTalListViewItem * itemBelow() { return (KviTalListViewItem *)TQListViewItem::itemBelow(); };
};

struct KviTalCheckListItemPrivate;

class KVILIB_API KviTalCheckListItem : public KviTalListViewItem
{
public:
	enum Type {
		RadioButton,
		CheckBox,
		Controller,
		RadioButtonController=Controller,
		CheckBoxController
	};
	enum ToggleState { Off, NoChange, On };

	KviTalCheckListItem(KviTalCheckListItem *parent, const TQString &text,Type = RadioButtonController);
	KviTalCheckListItem(KviTalCheckListItem *parent, KviTalListViewItem *after,const TQString &text, Type = RadioButtonController);
	KviTalCheckListItem( KviTalListViewItem *parent, const TQString &text,Type = RadioButtonController );
	KviTalCheckListItem( KviTalListViewItem *parent, KviTalListViewItem *after,const TQString &text, Type = RadioButtonController );
	KviTalCheckListItem( KviTalListView *parent, const TQString &text,Type = RadioButtonController );
	KviTalCheckListItem( KviTalListView *parent, KviTalListViewItem *after,const TQString &text, Type = RadioButtonController );
	KviTalCheckListItem( KviTalListViewItem *parent, const TQString &text,const TQPixmap & );
	KviTalCheckListItem( KviTalListView *parent, const TQString &text,const TQPixmap & );
	~KviTalCheckListItem();

	void paintCell( TQPainter *,const TQColorGroup & cg,int column, int width, int alignment );
    virtual void paintFocus( TQPainter *, const TQColorGroup & cg,
			     const TQRect & r );
    int width( const TQFontMetrics&, const KviTalListView*, int column) const;
    void setup();

    virtual void setOn( bool ); // ### should be replaced by setChecked in ver4
    bool isOn() const { return on; }
    Type type() const { return myType; }
    TQString text() const { return KviTalListViewItem::text( 0 ); }
    TQString text( int n ) const { return KviTalListViewItem::text( n ); }

    void setTristate( bool );
    bool isTristate() const;
    ToggleState state() const;
    void setState( ToggleState s);

    int rtti() const;
    static int RTTI;

protected:
    void activate();
    void turnOffChild();
    virtual void stateChange( bool );

private:
    void init();
    ToggleState internalState() const;
    void setStoredState( ToggleState newState, void *key );
    ToggleState storedState( void *key ) const;
    void stateChange( ToggleState s );
    void restoreState( void *key, int depth = 0 );
    void updateController( bool update = TRUE , bool store = FALSE );
    void updateStoredState( void *key );
    void setState( ToggleState s, bool update, bool store );
    void setCurrentState( ToggleState s );

    Type myType;
    bool on; // ### remove in ver4
    KviTalCheckListItemPrivate *d;
};


#define KviTalListViewItemIterator TQListViewItemIterator 

#endif // _KVI_TAL_LISTVIEW_QT3_H_
