#ifndef _DIALOG_H_
#define _DIALOG_H_
//=============================================================================
//
//   File : dialog.h
//   Created on Fri 10 Feb 2006 18:52:18 by Szymon Stefanek
//   Based on dlg_options.h: Tue Jun 11 2000 02:39:12 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2000-2006 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================


#include <tqdialog.h>
#include "kvi_tal_listview.h"
#include <tqstringlist.h>
#include "kvi_optionswidget.h"

#include "instances.h"

class TQLabel;
class KviTalWidgetStack;
class TQPushButton;
class TQLineEdit;
class TQToolButton;

class KviGeneralOptionsFrontWidget : public KviOptionsWidget
{
	TQ_OBJECT
  
public:
	KviGeneralOptionsFrontWidget(TQWidget *parent,const TQString &szText);
	~KviGeneralOptionsFrontWidget();
};

class KviOptionsListViewItem : public KviTalListViewItem
{
public:
	KviOptionsListViewItem(KviTalListView *parent,KviOptionsWidgetInstanceEntry * e);
	KviOptionsListViewItem(KviTalListViewItem *parent,KviOptionsWidgetInstanceEntry * e);
	~KviOptionsListViewItem();
public:
	KviOptionsWidgetInstanceEntry * m_pInstanceEntry;
	KviOptionsWidget              * m_pOptionsWidget;
	bool m_bHighlighted;
public:
	void setHighlighted(bool b){ m_bHighlighted = b; };
protected:
	virtual void paintCell(TQPainter * p,const TQColorGroup & cg,int column,int width,int align);
};

class KviOptionsDialog : public TQDialog
{
	TQ_OBJECT
  
public:
	KviOptionsDialog(TQWidget * par,const TQString &szGroup); 
	~KviOptionsDialog();
private:
	KviTalListView    * m_pListView;
	TQLabel       * m_pCategoryLabel;
	KviTalWidgetStack * m_pWidgetStack;
	KviGeneralOptionsFrontWidget* m_pFrontWidget;
	TQString        m_szGroup;
	TQLineEdit    * m_pSearchLineEdit;
	TQToolButton  * m_pSearchButton;
private:
	void recursiveCommit(KviOptionsListViewItem *it);
	void fillListView(KviTalListViewItem * p,KviPointerList<KviOptionsWidgetInstanceEntry> * l,const TQString &szGroup,bool bNotContainedOnly = false);
	//KviOptionsListViewItem * showHiddenChildren(KviTalListViewItem * p,KviPointerList<KviOptionsWidgetInstanceEntry> * l);
	KviOptionsListViewItem * findItemByPage(KviOptionsListViewItem *it,KviOptionsWidget * pPage);
private slots:
	void listViewItemSelectionChanged(KviTalListViewItem *it);
	void applyClicked();
	void okClicked();
	void cancelClicked();
	void pageWantsToSwitchToAdvancedPage(KviOptionsWidget * pPage);
	void searchClicked();
	void searchLineEditTextChanged(const TQString &);
protected:
	void apply(bool bDialogAboutToClose);
	virtual void closeEvent(TQCloseEvent *e);
	virtual void keyPressEvent( TQKeyEvent * e );
	bool recursiveSearch(KviOptionsListViewItem * pItem,const TQStringList &lKeywords);
public:
	void search(const TQString &szKeywords);
	void search(const TQStringList &lKeywords);
};


#endif //!_DIALOG_H_
