/***************************************************************************
                          kxetexteditordialog.h  -  description
                             -------------------
    begin                : Ne pro 14 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXETEXTEDITORDIALOG_H
#define KXETEXTEDITORDIALOG_H

#include <tqwidget.h>
#include <tqstring.h>
#include <tqsyntaxhighlighter.h>

#include <ktextedit.h>

#include "kxetexteditordialogbase.h"
#include "kxesyntaxhighlighter.h"

/**Dialog for editing raw XML as text
  *@author Lumir Vanek
  */

class KXETextEditorDialog : public KXETextEditorDialogBase
{
   Q_OBJECT
public:
	KXETextEditorDialog(TQWidget *parent=0, const char *name=0);
	~KXETextEditorDialog();

  TQString editorText() const { return m_pTextEditor->text(); }
  void setEditorText(const TQString strText) { m_pTextEditor->setText(strText); }

public slots:

  /**
   * Changes syntax highlighting colors.
   */
  void slotTextViewSettingsChanged();

protected:
  bool validateXml(bool);

protected slots:
  // fired, when user press Validate button
  virtual void slotValidate();

  // fired, when user change text editor contents
  void slotTextChanged();

  // fired, when user press OK button
  virtual void accept();

private:
  KXESyntaxHighlighter *m_pSyntaxHighlighter;
};

#endif
